<?php

$widget_post = blackdsn_base_attr();

$widget_post->add_render_attribute( 'next-post', [
	'class' => [
		'pagination-post d-flex align-items-center border-style border-radius mt-section'
	]
] );

$widget_post->add_render_duplicate_attribute( [ 'next', 'prev' ], [
	'class' => 'pagination-item w-100 p-20'
] );
$widget_post->add_render_attribute( 'next', 'class', 'text-right' );


$next_post = get_next_post();

if ( $next_post ) {
	$widget_post->add_render_attribute( 'next-link', [ 'href' => esc_url( get_permalink( $next_post ) ) ] );
} else {
	$widget_post->add_render_attribute( 'next-link', [ 'class' => 'd-none pointer-events', 'href' => '#0' ] );
}


$prev_post = get_previous_post();

if ( $prev_post ) {
	$widget_post->add_render_attribute( 'prev-link', [ 'href' => esc_url( get_permalink( $prev_post ) ) ] );
} else {
	$widget_post->add_render_attribute( 'prev-link', [ 'class' => 'd-none pointer-events', 'href' => '#0' ] );
}


$widget_post->add_render_attribute( 'title-link', [ 'class' => 'title-block word-wrap' ] );
$widget_post->add_render_attribute( 'span-link', [ 'class' => 'mb-5' ] );


?>


<div <?php $widget_post->print_render_attribute_string( 'next-post' ); ?> >

	<?php

	printf( '<div %1$s><a %2$s><span %3$s>%4$s</span><h4 %5$s>%6$s</h4></a></div>',
		$widget_post->get_render_attribute_string( 'prev' ),
		$widget_post->get_render_attribute_string( 'prev-link' ),
		$widget_post->get_render_attribute_string( 'span-link' ),
		esc_html__( 'PREVIOUS', 'blackdsn' ),
		$widget_post->get_render_attribute_string( 'title-link' ),
		$prev_post ? get_the_title( $prev_post ) : ''
	);

	?>


    <div class="icon p-20 border-right border-left">
        <a class="h-100 heading-color" href="#">
            <i class="fas fa-th-large"></i>
        </a>
    </div>
	<?php

	printf( '<div %1$s><a %2$s><span %3$s>%4$s</span><h4 %5$s>%6$s</h4></a></div>',
		$widget_post->get_render_attribute_string( 'next' ),
		$widget_post->get_render_attribute_string( 'next-link' ),
		$widget_post->get_render_attribute_string( 'span-link' ),
		esc_html__( 'NEXT', 'blackdsn' ),
		$widget_post->get_render_attribute_string( 'title-link' ),
		$next_post ? get_the_title( $next_post ) : ''
	);

	?>
</div>