<?php
$shortcode = blackdsn_doc_elementor();

if ( ! $shortcode->getVal( 'show_menu', '1' ) )
	return;


$menu_type = $shortcode->getVal( 'menu_type', "auto" );
if ( $menu_type === "auto" )
	$menu_type = get_theme_mod( 'menu_type', '' );


$my_menu = wp_get_nav_menu_object( blackdsn_get_option_array( get_nav_menu_locations(), 'primary', 0 ) );

?>

<header id="site_menu_header"
        class="site-header  dsn-container d-none <?php echo esc_attr( $menu_type ) ?>">
	<?php blackdsn_get_template_header( 'site', 'logo' ); ?>
    <div class="p-relative dsn-container">
        <nav class="main-navigation ">
            <div class="menu-cover-title header-container dsn-container"><?php esc_attr_e( "MENU", 'blackdsn' ); ?></div>
            <?php

            wp_nav_menu( array(
                'theme_location' => 'primary',
                'menu'           => $shortcode->getVal( 'menu_id', 0 ),
                'menu_id'        => 'dsn-primary-list',
                'menu_class'     => implode(" ",['primary-nav h2' , ( $my_menu && $my_menu->count >= 10 ) ? 'list-scroll' : '']),
                'container'      => false,
                'depth'          => 3,
                'fallback_cb'    => 'BlackdsnClassNavWalker::fallback',
                'walker'         => new \BlackdsnClassNavWalker(),
            ) );
            ?>
            <?php blackdsn_get_template_header( 'site', 'content' ); ?>
        </nav>
        <?php blackdsn_get_template_header( 'site', 'toggle' ); ?>
        <?php blackdsn_get_template_header( 'sidebar', 'cart' ); ?>
    </div>

    <div class="bg-load background-main"></div>

    <svg width="100%" height="100%" viewBox="0 0 100 100" preserveAspectRatio="none"
         class="bg-load dsn-svg-transition">
        <path vector-effect="non-scaling-stroke" d="M 0 100 V 100 Q 50 100 100 100 V 100 z"/>
    </svg>
</header>