<?php


if ( ! get_theme_mod( 'page_preloader', '1' ) ) {
	return;
}

$image = blackdsn_get_logo();
$image .= blackdsn_get_logo( 'custom_logo_dark', 'logo-dark' );
?>

<div id="dsn_preloader" class="preloader">

    <div class="dsnload p-absolute">
		<?php
		$loadImage = sprintf( '<span class="dsnload__img">%s</span>', $image );
		$sibling   = sprintf( '<span class="dsnload__row dsnload__row--sibling">%s</span>', $loadImage );
		printf( '<span class="dsnload__row">%1$s</span>%2$s', $loadImage, str_repeat( $sibling, 3 ) )
		?>
    </div>

    <svg width="100%" height="100%" viewBox="0 0 100 100" class="v-middle"
         preserveAspectRatio="xMinYMin meet" fill="none">
        <linearGradient id="linearColors" x1="0" y1="0" x2="1" y2="1">
            <stop offset="0%" stop-color="var(--theme-color)"></stop>
            <stop offset="50%" stop-color="var(--border-color)"></stop>
            <stop offset="100%" stop-color="var(--assistant-color)"></stop>
        </linearGradient>
        <path class="dsn-progress-path" d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"/>
    </svg>
    <div class="loading-circle v-middle">
        <p class="loading-count v-middle">0</p>
    </div>

    <span class="loading-text text-uppercase mt-30"><?php esc_attr_e( "Chargement ...", 'blackdsn' ); ?></span>
    <div class="bg-load background-section d-flex align-items-end">
        <svg class="dsn-separator-bottom dsn-icon-assistant-color" width="100%" height="100%" viewBox="0 0 100 10" preserveAspectRatio="none">
            <path class="path-anim separator__path" data-dsn-to="M 0 0 C 40 0 55 0 100 0 L 0 0 Z"
                  vector-effect="non-scaling-stroke" d="M 0 0 C 40 16 75 10 100 0 L 0 0 Z"></path>
        </svg>
    </div>

</div>