<?php
$shortcode = blackdsn_doc_elementor();

if ( ! $shortcode->getVal( 'show_header', '1' ) || is_404() || blackdsn_is_elementor_library() || blackdsn_is_product() )
	return;


$id_page = blackdsn_get_id_shop();

/**
 * Widget
 */
$widget = $shortcode->getWidgetBase();


$isPattern = true;

if (  is_home() || is_archive() || blackdsn_is_shop() )
	$isPattern = true;
elseif ( has_post_thumbnail() || $shortcode->getVal( 'show_background_video', false ) && $shortcode->getVal( 'dsn_video_link', false ) )
	$isPattern = false;


/**
 *
 * Header
 *
 */

$widget->add_render_attribute( 'dsn-header', [
	'id'    => 'dsn_header',
	'class' => [
		'dsn-header-animation',
		$shortcode->getVal( 'image_type' ),
		$shortcode->getVal( 'show_box_shadow', 'show-box-shadow' ),
		$isPattern ? 'header-normal ' : 'dsn-container section-padding'
	]
] );

if ( in_array( $shortcode->getVal( 'image_type' ), [ 'right-img', 'left-img' ] ) && ! $isPattern )
	$widget->add_render_attribute( 'dsn-header', 'class', 'v-dark-head-mobile' );
elseif ( ! $isPattern )
	$widget->add_render_attribute( 'dsn-header', 'class', 'v-dark-head' );


/**
 * Hero Content
 */
$widget->add_render_attribute( 'hero-content', [
	'id'    => 'hero_content',
	'class' => [
		'd-flex p-relative h-100 dsn-hero-parallax-title',
		$shortcode->getVal( 'text_layout', 'container' )
	]
] );


?>
<header <?php $widget->print_render_attribute_string( 'dsn-header' ); ?>>
    <div class="entry-header p-relative over-hidden">
		<?php
		blackdsn_get_template_header( 'header', 'bg', array( 'bg' => 'full-width', 'shortcode' => $shortcode ) );
		?>


        <div <?php $widget->print_render_attribute_string( 'hero-content' ); ?> >
            <div class="content p-relative ">
                <div class="intro-project w-100">
                    <div class="intro-title ">


						<?php

						blackdsn_get_template_header( 'content/header', 'category', [ 'shortcode' => $shortcode ] );
						blackdsn_get_template_header( 'content/header', 'title', array( 'shortcode' => $shortcode ) );

						if ( $subtitle = blackdsn_subtitle_head( '', false, $shortcode ) )
							printf( '<p class="subtitle-meta metas p-relative mt-10">%s</p>', $subtitle );

						?>


                    </div>

                </div>

            </div>

        </div>


    </div>

	<?php blackdsn_get_template_header( 'content/header', 'link', array( 'shortcode' => $shortcode ) ); ?>

	<?php if ( has_post_thumbnail() ): ?>
        <a href="#page_wrapper" rel="nofollow" class="dsn-scroll-bottom"
           data-dsn-option='{"ease": "power4.inOut" , "duration" : 1.5}'>
            <div class="text"><?php esc_html_e( 'SCROLL', 'blackdsn' ) ?></div>
        </a>
	<?php endif; ?>

</header>