<?php
if(blackdsn_is_shop())
    return ;
$args = wp_parse_args( $args, [
	'shortcode' => blackdsn_doc_elementor()
] );

/**
 * @var $shortcode \DesignGrid\DsnDocElementor
 */
$shortcode = $args['shortcode'];





$header_widget = $shortcode->getWidgetBase();


/*
 * Option Header background (Image, video) Page
 */
$opacity_overlay = $shortcode->getValueNumber( 'opacity_overlay', 5 );

$header_widget->add_render_duplicate_attribute( [ 'img', 'vid' ], [
	'class'         => 'p-absolute dsn-hero-parallax-img over-hidden before-z-index z-index-1',
	'id'            => 'hero_image',
	'data-dsn-ajax' => 'img',
	'data-overlay'  => $opacity_overlay,
] );

if ( isset( $args ) && blackdsn_get_option_array( $args, 'bg' ) ) {
	$header_widget->add_render_duplicate_attribute( [ 'img', 'vid' ], 'class', 'full-width' );
}


blackdsn_get_img( array(
	'before'    => sprintf( '<div %s>', $header_widget->get_render_attribute_string( "img" ) ),
	'after'     => '</div>',
	'before_v'  => sprintf( '<div %s>', $header_widget->get_render_attribute_string( "vid" ) ),
	'after_v'   => '</div>',
	'type'      => 'img',
	'size'      => $shortcode->getVal( 'image_size', 'full' ),
	'attr'      => array(
		'class'   => 'cover-bg-img transform-3d',
		'loading' => false,
	),
	'shortcode' => $shortcode
) );