<?php

$args = wp_parse_args( $args, [
	'shortcode' => blackdsn_doc_elementor()
] );

/**
 * @var $shortcode \DesignGrid\DsnDocElementor
 */
$shortcode = $args['shortcode'];

$widget = $shortcode->getWidgetBase();

if ( empty( $shortcode->getVal( 'head_link', [ 'url' => '' ] )['url'] ) )
	return;

$widget->add_link_attributes( 'head_link', $shortcode->getVal( 'head_link', [] ), [
	'class'    => 'background-main move-circle link-project p-absolute',
	'data-dsn' => 'parallax',
] );

?>

<a <?php $widget->print_render_attribute_string( 'head_link' ); ?>>

	<?php echo esc_html( $shortcode->getVal( 'text_link' ) ) ?>

    <svg viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg">
        <path d="M213.333333 750.506667L665.173333 298.666667H384V213.333333h426.666667v426.666667h-85.333334V358.826667L273.493333 810.666667 213.333333 750.506667z"/>
    </svg>

</a>