<?php

if ( ! class_exists( 'blackdsnShortCode' ) || ! function_exists( "blackdsn_default_social" ) || ! get_theme_mod( 'effect_dsn_socials', '1' ) )
	return;


$items = get_theme_mod( 'dsn_socials', blackdsn_default_social() );

if ( ! count( $items ) || ! is_array( $items ) ) {
	return;
}

?>


<div class="social-side d-flex align-items-center flex-column justify-content-center">

    <ul class="socials d-flex flex-column-reverse">


		<?php foreach ( $items as $index => $item ):
			$social = new blackdsnShortCode( $item );
			$social->setSubBlock( $item );

			$init_name = $social->getSubVal( "init_name" );
			$icon      = $social->getSubVal( "icon" );

			if ( ! $init_name || ! $icon ) {
				continue;
			}

			?>

            <li style="--dsn-index-animate : <?php echo esc_attr( $index ) ?>;">
                <a href="<?php echo esc_url( $social->getSubVal( 'link' ) ) ?>" target="_blank"
                   rel="nofollow">
					<?php printf( '<i class="%s"></i><span>%s</span>', $icon, $init_name ) ?>
                </a>
            </li>

		<?php endforeach; ?>

    </ul>
    <div class="icon">
		<?php esc_html_e( "SUIVEZ-NOUS", 'blackdsn' ); ?>
    </div>
</div>
