<?php


if ( ! function_exists( 'blackdsn_include_wooCommerce' ) ) :

	function blackdsn_include_wooCommerce() {
		return class_exists( 'WooCommerce' );
	}
endif;


if ( ! function_exists( 'blackdsn_is_shop' ) ) :
	/**
	 * Is_shop - Returns true when viewing the product type archive (shop).
	 *
	 * @return bool
	 */
	function blackdsn_is_shop() {

		if ( blackdsn_include_wooCommerce() ) {
			return is_shop();
		}

		return false;
	}
endif;

if ( ! function_exists( 'blackdsn_get_id_shop' ) ) :

	/**
	 * Retrieve page ids - used for myaccount, edit_address, shop, cart, checkout, pay, view_order, terms. returns -1 if no page is found.
	 *
	 * @param string $page Page slug.
	 *
	 * @return int
	 */
	function blackdsn_get_id_shop() {

		if ( blackdsn_is_shop() ) {
			return wc_get_page_id( 'shop' );
		}

		return false;
	}
endif;


if ( ! function_exists( 'blackdsn_is_product' ) ) {

	/**
	 * Is_product - Returns true when viewing a single product.
	 *
	 * @return bool
	 */
	function blackdsn_is_product() {
		return is_singular( array( 'product' ) );
	}
}