<?php


/**
 *
 *  ============================
 *         Slug Project
 *  ============================
 *
 *  - Retrieves an option value based on an Slug Work name.
 *
 */
if ( ! function_exists( 'blackdsn_doc_elementor' ) ) :

	function blackdsn_doc_elementor( $post_id = null ) {
		return new \DesignGrid\DsnDocElementor( $post_id );
	}

endif;


/**
 *
 *  ============================
 *         Slug Project
 *  ============================
 *
 *  - Retrieves an option value based on an Slug Work name.
 *
 */
if ( ! function_exists( 'blackdsn_project_slug' ) ) :

	function blackdsn_project_slug() {
		return 'blackdsn-portfolio';
	}

endif;
/**
 *
 *  ============================
 *         Slug Category Project
 *  ============================
 *
 *  - Retrieves an option value based on an Slug Work name.
 *
 */
if ( ! function_exists( 'blackdsn_category_slug' ) ) :

	function blackdsn_category_slug() {

		return 'dsn-blackdsn-categories';

	}

endif;


/**
 *
 *  ============================
 *         Slug Project
 *  ============================
 *
 *  - Retrieves an option value based on an Slug Work name.
 *
 */
if ( ! function_exists( 'blackdsn_story_slug' ) ) :

	function blackdsn_story_slug() {
		return 'blackdsn-story';
	}

endif;


if ( ! function_exists( 'blackdsn_is_work' ) ) :

	function blackdsn_is_work( $post = null ) {
		return get_post_type( $post ) === blackdsn_project_slug();
	}

endif;
if ( ! function_exists( 'blackdsn_is_elementor_library' ) ) :

	function blackdsn_is_elementor_library( $post = null ) {
		return get_post_type( $post ) === 'elementor_library';
	}

endif;


/**
 *
 *  ============================
 *     Get Value From ACF
 *  ============================
 *
 *
 *
 */
if ( ! function_exists( 'blackdsn_acf_option' ) ) :

	function blackdsn_acf_option( $id, $default = false, $post_id = false, $format_value = true ) {

		$output = null;
		if ( class_exists( 'acf' ) ) {
			$output = get_field( $id, $post_id, $format_value );
		}

		if ( $output !== null ) {
			return $output;
		}

		return $default;

	}

endif;


/**
 *
 *  ============================
 *         Custom Filed
 *  ============================
 *
 *  - Replace title page custom Title.
 *
 */
if ( ! function_exists( 'blackdsn_custom_title' ) ) :

	function blackdsn_custom_title( $post = null ) {


		if ( blackdsn_is_shop() ) {
			return esc_html__("OUR SHOP" , 'blackdsn');
		}else if ( is_home() ) {
			return get_theme_mod( 'home_custom_title', 'Our Stories' );
		} elseif ( ( is_archive() || is_search() ) && ! blackdsn_is_shop() ) {
			return blackdsn_get_option_array( blackdsn_get_archives(), 'title' );
		}

		$shortcode = blackdsn_doc_elementor( $post );

		if ( $custom_title = $shortcode->getVal( 'custom_title', '' ) ) {
			return $custom_title;
		}


		return get_the_title( $post );

	}

endif;


/**
 *
 *  ============================
 *         Custom Filed
 *  ============================
 *
 *  - Replace title page custom Title.
 *
 */
if ( ! function_exists( 'blackdsn_description_head' ) ) :

	function blackdsn_description_head( $default = '', $post_id = false ) {

		if ( is_home() ) {
			return get_theme_mod( 'home_custom_subtitle', '' );
		} elseif ( is_archive() || is_search() ) {
			return blackdsn_get_option_array( blackdsn_get_archives(), 'name' );
		}

		return blackdsn_get_option_pages( 'description_header', $default, $post_id );
	}

endif;


/**
 *
 *  ============================
 *     Get Settings Page
 *  ============================
 *
 *
 *
 */
if ( ! function_exists( 'blackdsn_get_option_page_elementor' ) ) :
	function blackdsn_get_option_page_elementor( $id, $post_id = null ) {

		if ( ! class_exists( '\Elementor\Core\Settings\Manager' ) ) {
			return false;
		}

		if ( $post_id === null || $post_id === false ) {
			$post_id = get_the_ID();
		}

		$page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );
		$page_settings_model   = $page_settings_manager->get_model( $post_id );

		return $page_settings_model->get_settings( $id );

	}

endif;

/**
 *
 *  ============================
 *     Get Settings Page
 *  ============================
 *
 *
 *
 */
if ( ! function_exists( 'blackdsn_get_option_pages' ) ) :
	function blackdsn_get_option_pages( $id, $default = false, $post_id = null ) {
		return blackdsn_acf_option( $id, $default, $post_id );
	}

endif;


if ( ! function_exists( 'blackdsn_get_option_array' ) ) :

	function blackdsn_get_option_array( $options, $id, $default = false ) {


		$options = (object) $options;
		if ( isset( $options->{$id} ) && $options->{$id} !== null ) {
			return $options->{$id};
		}

		return $default;
	}

endif;

/**
 *
 *  ============================
 *     Get Number Overlay Image
 *  ============================
 *
 *
 *
 */
if ( ! function_exists( 'blackdsn_position_image' ) ) :

	function blackdsn_position_image( $default = '50', $post_id = false ) {
		return blackdsn_get_option_pages( 'background_option_position_image_position_x', $default,
				$post_id ) . '% ' . blackdsn_get_option_pages( 'background_option_position_image_position_y', $default,
				$post_id ) . '%';
	}

endif;


if ( ! function_exists( 'blackdsn_is_lazy_image' ) ) :

	/**
	 * @return  boolean
	 */
	function blackdsn_is_lazy_image() {
		return get_theme_mod( 'dsn_lazy_image' );
	}
endif;


/**
 *
 *  ============================
 *     Get Number Overlay Image
 *  ============================
 *
 *
 *
 */
if ( ! function_exists( 'blackdsn_overlay' ) ) :

	/**
	 * @return number | string
	 */
	function blackdsn_overlay( $default = '4', $post_id = null ) {
		return blackdsn_doc_elementor( $post_id )->getValueNumber( 'opacity_overlay', $default );
	}

endif;


if ( ! function_exists( 'blackdsn_base_attr' ) ) :

	function blackdsn_base_attr() {

		return new \DesignGrid\BlackdsnBaseAttr();
	}

endif;


if ( ! function_exists( 'blackdsn_menu_layout' ) ) :

	function blackdsn_menu_layout( $default = 'hamburger-menu' ) {

		return blackdsn_get_option_array( blackdsn_get_option_pages( 'nav_menu', false, blackdsn_get_id_shop() ),
			'menu_type', $default );
	}

endif;

if ( ! function_exists( 'blackdsn_menu_id' ) ) :

	function blackdsn_menu_id( $default = 0 ) {

		return blackdsn_get_option_array( blackdsn_get_option_pages( 'nav_menu' ), 'menu_id', $default );
	}

endif;

if ( ! function_exists( 'blackdsn_show_background_video' ) ) :

	function blackdsn_show_background_video( $post_id = null ) {


		return blackdsn_get_option_pages( 'show_background_video', false,
				$post_id ) && blackdsn_get_option_pages( 'background_video', false, $post_id );
	}

endif;

if ( ! function_exists( 'blackdsn_background_header' ) ) :

	function blackdsn_background_header( $default = 'default' ) {
		return blackdsn_get_option_array( blackdsn_get_option_pages( 'background_header', false,
			blackdsn_get_id_shop() ), 'color', $default );
	}

endif;

if ( ! function_exists( 'blackdsn_background_header_type' ) ) :

	function blackdsn_background_header_type( $default = 'background-section' ) {
		return blackdsn_get_option_array( blackdsn_get_option_pages( 'background_header', false,
			blackdsn_get_id_shop() ), 'type_background', $default );
	}

endif;


if ( ! function_exists( 'blackdsn_overlay_blend_mode' ) ) :

	function blackdsn_overlay_blend_mode() {
		return [
			'none'        => 'Normal',
			'multiply'    => 'Multiply',
			'screen'      => 'Screen',
			'overlay'     => 'Overlay',
			'darken'      => 'Darken',
			'lighten'     => 'Lighten',
			'color-dodge' => 'Color Dodge',
			'saturation'  => 'Saturation',
			'color'       => 'Color',
			'luminosity'  => 'Luminosity',
			'exclusion'   => 'Exclusion',
		];
	}

endif;

if ( ! function_exists( 'blackdsn_author_full_name' ) ) :

	function blackdsn_author_full_name() {
		$first_name = get_the_author_meta( 'first_name' );
		$last_name  = get_the_author_meta( 'last_name' );

		if ( ! empty( $first_name ) or ! empty( $last_name ) ) {
			return esc_html( $first_name ) . ' ' . esc_html( $last_name );
		}


		return esc_html( get_the_author() );
	}

endif;


/**
 * @return array [id , name , title , description]
 */
if ( ! function_exists( 'blackdsn_get_archives' ) ) :

	function blackdsn_get_archives() {


		if ( is_category() ) {
			$cat = get_category( get_query_var( 'cat' ) );

			return array(
				'id'          => 'category',
				'name'        => esc_html__( 'Categories Archives', 'blackdsn' ),
				'title'       => $cat->name,
				'description' => $cat->category_description,
			);
		} elseif ( is_tag() ) {
			return array(
				'id'          => 'tag',
				'name'        => esc_html__( 'Tags Archives', 'blackdsn' ),
				'title'       => single_tag_title( '', false ),
				'description' => '',

			);
		} elseif ( is_search() ) {
			return array(
				'id'          => 'search',
				'title'       => esc_html__( 'Search', 'blackdsn' ),
				'name'        => get_search_query(),
				'description' => '',
			);
		} elseif ( is_author() ) {
			return array(
				'id'          => 'author',
				'name'        => esc_html__( 'Author Archives', 'blackdsn' ),
				'title'       => blackdsn_author_full_name(),
				'description' => get_the_author_meta( 'description' ),
			);
		} elseif ( is_day() ) {
			return array(
				'id'          => 'day',
				'name'        => esc_html__( 'Daily Archives', 'blackdsn' ),
				'title'       => get_the_date(),
				'description' => '',
			);
		} elseif ( is_month() ) {

			return array(
				'id'          => 'month',
				'name'        => esc_html__( 'Monthly Archives', 'blackdsn' ),
				'title'       => get_the_date( 'F Y' ),
				'description' => '',
			);
		} elseif ( is_year() ) {
			return array(
				'id'          => 'year',
				'name'        => esc_html__( 'Yearly Archives', 'blackdsn' ),
				'title'       => get_the_date( 'Y' ),
				'description' => '',
			);
		} elseif ( is_404() ) {
			return array(
				'id'          => 'error400',
				'name'        => esc_html__( '404', 'blackdsn' ),
				'title'       => esc_html__( 'Oops! Not Found', 'blackdsn' ),
				'description' => esc_html__( 'It looks like nothing was found at this location. Maybe try a search?',
					'blackdsn' ),
			);
		} elseif ( is_archive() && get_queried_object() !== null && isset( get_queried_object()->taxonomy ) ) {
			$obj = get_queried_object();


			return array(
				'id'          => $obj->taxonomy,
				'name'        => $obj->taxonomy === blackdsn_category_slug() ? esc_html__( 'Categories Archives',
					'blackdsn' ) : '',
				'title'       => $obj->name,
				'description' => ''
			);
		}


		return array(
			'id'          => '',
			'name'        => '',
			'title'       => '',
			'description' => ''
		);

	}

endif;


/**
 *
 *  ============================
 *         Custom Filed
 *  ============================
 *
 *  - Replace title page custom Title.
 *
 */
if ( ! function_exists( 'blackdsn_subtitle_head' ) ) :


	function blackdsn_subtitle_head( $default = '', $post_id = false, $shortcode = null ) {

		if ( is_home() ) {
			return get_theme_mod( 'home_custom_subtitle', 'NEWS & IDEAS' );
		} elseif ( is_archive() || is_search() ) {
			return blackdsn_get_option_array( blackdsn_get_archives(), 'name' );
		}

		if ( $shortcode )
			return $shortcode->getVal( 'subtitle', $default );

		return blackdsn_get_option_page_elementor( 'subtitle', $post_id );
	}

endif;


/**
 * @return string  Buttons pagination
 */
if ( ! function_exists( 'blackdsn_buttons_pagination' ) ) :

	function blackdsn_buttons_pagination( $label = '', $class = '' ) {
		$out = '<svg viewBox="0 0 52 52" xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" fill="#fff">';
		$out .= '<path d="M3 26.7h39.5v3.5c0 .3.1.5.4.6.2.1.5.1.7-.1l5.9-4.2c.2-.1.3-.3.3-.5s-.1-.4-.3-.5l-5.9-4.2c-.1-.1-.3-.1-.4-.1-.1 0-.2 0-.3.1-.2.1-.4.3-.4.6v3.5H3c-.4 0-.7.3-.7.7 0 .3.3.6.7.6z"></path>';
		$out .= '</svg>';
		$out .= '<span class="sm-title-block dsn-heading-title ' . esc_attr( $class ) . '">' . esc_html( $label ) . '</span>';


		return $out;

	}

endif;


/**
 * @return string  Buttons pagination
 */
if ( ! function_exists( 'blackdsn_background_reverse' ) ) :

	function blackdsn_background_reverse() {
		return blackdsn_get_option_pages( 'background_color', 'v-light' ) === 'v-light' ? 'v-dark' : 'v-light';

	}

endif;