<?php

/*
 *  @package blackdsn/inc
 *  =======================================
 *              Theme Support
 *  =======================================
 */


/**
 * This hook is called during each page load,
 * after the theme is initialized. It is generally used to perform basic
 * setup, registration, and init actions for a theme.
 */

add_action( 'after_setup_theme', function () {

    /**
     *
     * ===================================================
     *      Load the theme is translated strings.
     * ===================================================
     *  - Make theme available for translation
     *  - Translations can be filed in the /languages/ directory.
     *  it will be included in the translated strings by the $domain
     *
     */

    load_theme_textdomain( 'blackdsn', get_template_directory() . '/languages' );

    //--==== Enables post and comment RSS feed links to head ====--//
    add_theme_support( 'automatic-feed-links' );

    // Set content-width.
    global $content_width;
    if ( !isset( $content_width ) ) {
        $content_width = 960;
    }

    /*
         * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
	*/
    add_theme_support( 'title-tag' );


    /*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
    add_theme_support( 'post-thumbnails' );

    // Set post thumbnail size.
    set_post_thumbnail_size( 1200 );

    //--==== Cropping behavior for the image size is dependent on the value ====//
//
//    add_image_size( 'blackdsn-small-img', 150 );
//    add_image_size( 'blackdsn-media-img', 880 );
//    add_image_size( 'blackdsn-brand-img', 300 );


    /*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
    add_theme_support(
        'html5',
        array(
            'comment-list',
            'comment-form',
            'search-form',
            'gallery',
            'caption',
            'script',
            'style',
        )
    );


    /**
     * * Using a custom logo allows site owners to upload an image for their website,
     * which can be placed at the top of their website. It can be uploaded from Appearance > Header,
     */

    add_theme_support( 'custom-logo', array(
        'height' => 40,
        'width' => 250,
        'flex-height' => true,
        'flex-width' => true,
        'header-text' => array( 'site-title', 'site-description' ),
    ) );


    // Add theme support for selective refresh for widgets.
    add_theme_support( 'customize-selective-refresh-widgets' );


    // Add support for Block Styles.
    add_theme_support( 'wp-block-styles' );

    // Add support for editor styles.
    add_theme_support( 'editor-styles' );

    // Enqueue editor styles.
    add_editor_style( 'blackdsn-editor.css' );


    /**
     * ============================
     *     Editor Text Size Palette
     * ============================
     * A default set of sizes is provided, but themes can register their own and optionally lock users into picking from preselected sizes.
     */
    add_theme_support( 'editor-font-sizes', array(
        array(
            'name' => esc_html__( 'Small', 'blackdsn' ),
            'shortName' => esc_html__( 'S', 'blackdsn' ),
            'size' => 16,
            'slug' => 'small',
        ),
        array(
            'name' => esc_html__( 'Normal', 'blackdsn' ),
            'shortName' => esc_html__( 'N', 'blackdsn' ),
            'size' => 20,
            'slug' => 'normal',
        ),
        array(
            'name' => esc_html__( 'Medium', 'blackdsn' ),
            'shortName' => esc_html__( 'M', 'blackdsn' ),
            'size' => 24,
            'slug' => 'medium',
        ),
        array(
            'name' => esc_html__( 'Large', 'blackdsn' ),
            'shortName' => esc_html__( 'L', 'blackdsn' ),
            'size' => 36,
            'slug' => 'large',
        ),
        array(
            'name' => esc_html__( 'Huge', 'blackdsn' ),
            'shortName' => esc_html__( 'XL', 'blackdsn' ),
            'size' => 50,
            'slug' => 'huge',
        ),
    ) );


    /**
     * ============================
     *     Responsive Embeds
     * ============================
     * Themes must opt-in to responsive embeds.
     */
    add_theme_support( 'responsive-embeds' );


	update_option( 'elementor_viewport_sm', '200' );
	update_option( 'elementor_viewport_md', '200' );
	update_option( 'elementor_viewport_lg', '200' );
	update_option( 'elementor_viewport_mobile', '600' );

} );
