<?php

/*
 *  @package blackdsn/inc
 *  =======================================
 *              Helper Function
 *  =======================================
 */


/*
 *  =======================================
 *              Template Part
 *  =======================================
 */
if ( ! function_exists( 'blackdsn_get_template_parts' ) ) :
	function blackdsn_get_template_parts( $sulg, $name = null, $args = [] ) {
		get_template_part( 'template-parts/' . $sulg, $name, $args );
	}
endif;

if ( ! function_exists( 'blackdsn_get_template_header' ) ) :
	function blackdsn_get_template_header( $slug, $name = null, $args = [] ) {
		blackdsn_get_template_parts( 'header/' . $slug, $name, $args );
	}
endif;


if ( ! function_exists( 'blackdsn_get_logo' ) ) :
	function blackdsn_get_logo( $id = 'custom_logo', $classes = 'logo-light' ) {
		$id = get_theme_mod( $id );
		if ( $id ):
			return wp_get_attachment_image( $id, 'full', false, array(
				'class' => 'custom-logo ' . esc_attr( $classes ),
				'alt'   => get_bloginfo( 'name', 'display' ),
			) );
		endif;

		return '<h4 class="site-title ' . esc_attr( $classes ) . '">' . esc_html( get_theme_mod( 'title-logo-page',
				get_bloginfo( 'name' ) ) ) . '</h4>';

	}
endif;


/**
 *
 *  ============================
 *     Get Background Video
 *  ============================
 *
 */

if ( ! function_exists( 'blackdsn_background_video' ) ) :

	function blackdsn_background_video( $img, $class = '', $post_id = false, $attr = array() ) {


		$bg_video = blackdsn_get_option_array( $attr, 'background_video' );

		if ( $bg_video ) :
			echo '<video class="bg-image cover-bg dsn-video ' . esc_attr( $class ) . '" preload="none" data-dsn-poster="' . esc_url( $img ) . '" autoplay loop muted playsinline data-dsn-position="' . esc_attr( blackdsn_position_image( 50,
					$post_id ) ) . '" >';
			foreach ( $bg_video as $video ):

				if ( $type = blackdsn_get_type_video( $video['url'] ) ) {
					printf( '<source src="%s" type="%s">', esc_url( $video['url'] ), esc_attr( $type ) );
				}

			endforeach;

			echo esc_html__( 'Your browser does not support HTML5 video.', 'blackdsn' );
			echo '</video>';
		endif;

	}

endif;


/**
 *
 *  ============================
 *     Get Type
 *  ============================
 *
 */
if ( ! function_exists( 'blackdsn_get_type_video' ) ) :

	function blackdsn_get_type_video( $url ) {
		$format = array( 'webm', 'mp4', 'ogg' );
		$type   = wp_check_filetype( $url );
		if ( isset( $type['ext'] ) and in_array( $type['ext'], $format ) ) {
			return $type ['type'];
		}

		return false;

	}

endif;


/**
 *
 *  ============================
 *     Get Background Image SRC
 *  ============================
 *
 */
if ( ! function_exists( 'blackdsn_get_scr_img' ) ) :

	/**
	 * @return string
	 */
	function blackdsn_get_scr_img( $post = null, $size = 'post-thumbnail', $post_bg = true ) {
		if ( $post_bg && has_post_thumbnail( $post ) ) {
			return get_the_post_thumbnail_url( $post, $size );
		}

		return '';
	}

endif;


if ( ! function_exists( 'blackdsn_get_data_attr' ) ) :

	function blackdsn_get_data_attr( $attr = array() ) {
		$out = '';
		foreach ( $attr as $key => $value ) {
			$out .= $key . '="' . $value . '"';
		}

		return $out;
	}

endif;

/**
 *
 *  ============================
 *     Get Image Header
 *  ============================
 *
 */
if ( ! function_exists( 'blackdsn_the_post_thumbnail' ) ) :

	/**
	 * print Image header
	 */
	function blackdsn_the_post_thumbnail( $size = 'post-thumbnail', $attr = array(), $post = null, $echo = true ) {


		$attr = array_merge( $attr, array(
			'data-dsn-position' => esc_attr( blackdsn_position_image( 50, $post ) ),
		) );


		if ( blackdsn_is_lazy_image() ) {
			$thumbnail_id = get_post_thumbnail_id( $post );

			$attr = array_merge( $attr, array(
				'data-dsn-src'    => get_the_post_thumbnail_url( $post, $size ),
				'data-dsn-srcset' => wp_get_attachment_image_srcset( $thumbnail_id, $size ),
				'srcset'          => false,
				'sizes'           => wp_get_attachment_image_sizes( $thumbnail_id, $size ),
			) );
			$size = 'blackdsn-small-img';
		}


		if ( $echo ) {
			echo get_the_post_thumbnail( $post, $size, $attr );
		} else {
			return get_the_post_thumbnail( $post, $size, $attr );
		}

	}

endif;


/**
 *
 *  ============================
 *
 *     Header Feature Header
 *
 *  ============================
 *
 */
if ( ! function_exists( 'blackdsn_get_img' ) ) :

	function blackdsn_get_img( $attr = array(), $post_id = null ) {

		if ( ( is_home() || is_archive() ) && ! blackdsn_is_shop() ) {
			return;
		}


		$attr = shortcode_atts( array(
			'size'      => 'post-thumbnail',
			'type'      => true,
			'after'     => '',
			'before'    => '',
			'after_v'   => '',
			'before_v'  => '',
			'post'      => $post_id,
			'attr'      => array(),
			'class'     => '',
			'post_bg'   => true,
			'use_video' => true,
			'shortcode' => null,
		), $attr );

		/**
		 * @var $shortcode \DesignGrid\DsnDocElementor
		 */
		$shortcode = blackdsn_get_option_array( $attr, 'shortcode', blackdsn_doc_elementor( $attr['post'] ) );

		$use_video = $attr['use_video'] && $shortcode->getVal( 'show_background_video',
				false ) && $shortcode->getVal( 'dsn_video_link', false );


		if ( $use_video ) {

			printf( '%1$s', $attr['before_v'] );

			printf( '<video class="bg-image cover-bg dsn-video %1$s" src="%2$s" preload="none" data-dsn-poster="%3$s" autoplay loop muted playsinline  >%4$s</video>',
				esc_attr( $attr['class'] ),
				$shortcode->getVal( 'dsn_video_link', false ),
				blackdsn_get_scr_img( $attr['post'], $attr['size'], $attr['post_bg'] ),
				esc_html__( 'Your browser does not support HTML5 video.', 'blackdsn' )
			);


			printf( $attr['after_v'] );


		} else {
			if ( ! has_post_thumbnail( $attr['post'] ) ) {
				return;
			}
			echo '' . $attr['before']; // WPCS: XSS OK.
			if ( $attr['type'] === 'img' ) {
				blackdsn_the_post_thumbnail( $attr['size'], $attr['attr'], $attr['post'] );
			} else {
				printf( '<div data-dsn-bg="%s" %s></div>',
					blackdsn_get_scr_img( $attr['post'], $attr['size'], $attr['post_bg'] ),
					blackdsn_get_data_attr( $attr['attr'] )
				);
			}
			echo '' . $attr['after']; // WPCS: XSS OK.
		}

	}

endif;


/**
 *
 * Check pages is built With Elemntor
 *
 * @param string $post_id
 *
 * @return bool
 */
if ( ! function_exists( 'blackdsn_is_built_with_elementor' ) ) :
	function blackdsn_is_built_with_elementor( $post_id = null ) {

		if ( ! class_exists( '\Elementor\Plugin' ) ) {
			return false;
		}
		if ( $post_id == null ) {
			$post_id = get_the_ID();
		}

		$doc = \Elementor\Plugin::$instance->documents->get( $post_id ) ;
		if($doc)
			return $doc->is_built_with_elementor();


		return false;

	}
endif;

if ( ! function_exists( 'blackdsn_is_elementor_preview_mode' ) ) :
	/**
	 * Whether preview mode is active.
	 *
	 * @return bool
	 */
	function blackdsn_is_elementor_preview_mode() {
		if ( ! class_exists( '\Elementor\Plugin' ) ) {
			return false;
		}

		return \Elementor\Plugin::$instance->preview->is_preview_mode();
	}
endif;

if ( ! function_exists( 'blackdsn_get_next' ) ) :

	function blackdsn_get_next( $post_id = false ) {

		if ( $post_id ) {
			$next_post = $post_id;
		} else {
			$next_post = get_Next_post();
		}


		if ( ! $next_post && ! isset( $next_post->ID ) ) {

			global $post;

			$isOrder = class_exists( 'Hicpo' );
			if ( $isOrder ):
				$hicpo_options = get_option( 'hicpo_options' );
				if ( ! $hicpo_options ) {
					$isOrder = false;
				} elseif ( ! in_array( $post->post_type, $hicpo_options['objects'] ) ) {
					$isOrder = false;
				}

			endif;


			$get_num = 0;
			$args    = array(
				'post_type'      => $post->post_type,
				'order'          => 'ASC',
				'posts_per_page' => - 1,
			);
			if ( $isOrder ) {
				$args['orderby'] = 'menu_order';
				$args['order']   = 'DESC';
			}

			$recent = wp_get_recent_posts( $args, OBJECT );
			if ( $isOrder ) {
				$get_num = count( $recent ) - 1;
			}


			if ( ! empty( $recent ) && isset( $recent[ $get_num ] ) ) {
				$next_post = $recent[ $get_num ];
			} else {
				return false;
			}
		}

		return $next_post;
	}

endif;

/**
 *
 * Check pages is built With Elementor
 *
 * @param string $post_id
 *
 * @return bool
 */
if ( ! function_exists( 'blackdsn_get_option_pages_class' ) ) :
	function blackdsn_get_option_pages_class( $post_id = null ) {
		return blackdsn_is_built_with_elementor( $post_id ) ? 'single-post-with-element' : 'single-post';
	}
endif;

if ( ! function_exists( 'blackdsn_get_layout_page' ) ) :
	function blackdsn_get_layout_page( $post_id = null ) {


		if ( blackdsn_is_elementor_library() || is_404() )
			return '';
		elseif ( is_home() || is_archive() ) {
			return 'container';
		}

		return blackdsn_doc_elementor( $post_id )->getVal( 'page_layout', blackdsn_is_work() ? '' : 'container' );
	}
endif;