<?php

add_filter('body_class', function ($classes) {

    if (!class_exists('blackdsnHelperPlugin')) {
        $classes[] = 'v-dark';
    }


    if (blackdsn_is_work()):
        $classes[] = 'dsn-blackdsn-is-work';
    endif;


    if (get_theme_mod('ajax_pages')):
        $classes[] = 'dsn-ajax';
    endif;


    if (get_theme_mod('effect_cursor')):
        $classes[] = 'dsn-cursor-effect';
    endif;

    if (is_404()) {
        $classes[] = 'v-dark';
    }

    return $classes;


});

/**
 *
 *  Filters the list of CSS class names for the current post.
 *
 */


add_filter('post_class', function ($classes) {


    if ((is_singular() || blackdsn_is_work()) && !blackdsn_is_built_with_elementor()):
        $classes[] = 'section-margin';
    endif;

    return $classes;


});


do_action('blackdsn_developer', array(
    'views/pages/options/blackdsnWidgetLoader',
    'views/pages/options/option-pages',
    'views/pages/customizer/customizer-pages',

));

do_action('widget_loader');


/**
 * Contact Form 7: Don't Wrap Form Fields Into </p>
 */
add_filter('wpcf7_autop_or_not', '__return_false');


/*Contact form 7 remove span*/
add_filter('wpcf7_form_elements', function ($content) {
    $content = str_replace('<br />', '', $content);

    return $content;
});


if (get_theme_mod('ajax_pages')):
// JS assets
    add_action(
        'elementor/frontend/before_enqueue_scripts', function () {
        wp_enqueue_script('elementor-gallery'); // Elementor Gallery
    }
    );

// CSS assets
    add_action(
        'elementor/frontend/before_enqueue_styles', function () {
        wp_enqueue_style('elementor-gallery'); // Elementor Gallery
    }
    );
endif;


/**
 * Remove Elementor welcome splash screen
 * on the initial plugin activation
 * This prevents some issues when Merlin wizard
 * installs and activates the required plugins
 */
add_action('init', function () {
    delete_transient('elementor_activation_redirect');
});


/*
 * Admin Logo Link
 * */

add_filter('login_headerurl', function () {
    return esc_url(home_url('/'));
});


add_action('login_head', function () {
    if (get_theme_mod('admin_custom_logo')) {
        $src = get_theme_mod('admin_custom_logo');
        $width_logo = get_theme_mod('admin_width_number', 80);
        $width_logo = ((int)$width_logo === 0) ? 'auto' : $width_logo . 'px';
        $height_logo = get_theme_mod('admin_height_number', 80);
        $height_logo = ((int)$height_logo === 0) ? 'auto' : $height_logo . 'px';


        echo '<style type="text/css">
        h1 a {
            background: transparent url(' . esc_url($src) . ') 50% 50% no-repeat !important;
            width:' . esc_attr($width_logo) . '!important;
            height:' . esc_attr($height_logo) . '!important;
            background-size: cover !important;
        }
    </style>';
    }
});


add_action('wp_enqueue_scripts', function () {

    if (!blackdsn_is_built_with_elementor()) {
        return;
    }

    wp_dequeue_style('wp-block-library');
    wp_dequeue_style('wp-block-library-theme');
    wp_dequeue_style('wc-block-style'); // Remove WooCommerce block CSS
}, 100);


add_filter('comment_form_fields', function ($fields) {

    if (isset($fields['comment']))
        $comment_field = $fields['comment'];
    if (isset($fields['cookies'])) {
        $cookie_field = $fields['cookies'];
    }

    unset($fields['comment']);
    unset($fields['cookies']);
    if (isset($fields['comment']))
        $fields['comment'] = $comment_field;

    if (isset($fields['cookies']) && isset($cookie_field)) {
        $fields['cookies'] = $cookie_field;
    }


    return $fields;
});