<?php

/**
 *  --===== wp_enqueue_scripts --=====
 * is the proper hook to use when enqueuing items
 * that are meant to appear on the front end.
 * Despite the name, it is used for enqueuing both scripts and styles.
 *
 *  Custom CSS , JS For Web
 *
 */


class BlackdsnEnqueue {

	const VERSION = '1.2.3';


	public function __construct() {

		add_action( 'wp_enqueue_scripts', [ $this, 'en_css' ], 99 );
		add_action( 'wp_enqueue_scripts', [ $this, 'en_js' ], 10 );
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_elementor_preview_scripts' ], 99 );
		add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'enqueue_elementor_after_editor_scripts' ], 99 );

	}


	/**
	 * Cascading Style Sheets
	 */
	public function en_css() {
		global $wp_version;


		if ( (float) $wp_version < 5 ) {
			wp_enqueue_style( 'blackdsn-content', $this->asset_css() . '/content.css' );
		}

		wp_enqueue_style( 'blackdsn-showcase', $this->asset_css() . '/showcase.css', array(), self::VERSION );
		wp_enqueue_style( 'blackdsn-global', $this->asset_css() . '/global.min.css', array(), self::VERSION );
		wp_enqueue_style( 'blackdsn-custom-style', $this->asset_css() . '/style.css', array(
			'blackdsn-showcase',
			'blackdsn-global'
		), self::VERSION );

	}


	public function en_js() {

		// enable reply to comments
		if ( ( ! is_admin() ) && is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}


		wp_enqueue_script( 'modernizr', $this->asset_js_plugin() . '/modernizr.min.js', array(), '3.6.0', true );
		wp_enqueue_script( 'greensock', $this->asset_js_plugin() . '/greensock.min.js', array( 'jquery' ), '3.8.0',
			true );
		wp_enqueue_script( 'splitting', $this->asset_js_plugin() . '/splitting.min.js', array( 'jquery' ), false,
			true );
		wp_enqueue_script( 'isotope', $this->asset_js_plugin() . '/isotope.min.js', array( 'jquery' ), '3.0.6', true );
		wp_enqueue_script( 'fontawesome', $this->asset_js_plugin() . '/fontawesome.min.js', [], '5.15.4', true );

		wp_register_script( 'smooth-scrollbar', $this->asset_js_plugin() . '/smooth-scrollbar.min.js',
			array( 'jquery' ), '3.0.6', true );


		wp_enqueue_script( 'dsn-grid', $this->asset_js_plugin() . '/dsn-grid.min.js', array( 'jquery' ), '1.2.0',
			true );

		wp_register_script( 'blackdsn-scripts', $this->asset_js() . '/custom.js', array(
			'jquery'
		), self::VERSION, true );
		wp_enqueue_script( 'blackdsn-scripts' );


		wp_localize_script( 'blackdsn-scripts', 'dsnParam', array(
			'queries'   => esc_url( admin_url( 'admin-ajax.php?action=blackdsn_post_query' ) ),
			'ajaxStyle' => esc_url( admin_url( 'admin-ajax.php?action=blackdsn_style_query' ) ),
			'map'       => [
				'marker_icon' => esc_url( get_theme_mod( 'map_marker_icon',
					BLACKDSN_DIRECTORY_URI . 'assets/img/map-marker.png' ) ),
				'api'         => get_theme_mod( 'map_api', '' ),
			],
			'cursor'    => [
				'speed'      => (float) get_theme_mod( 'cursor_drag_speed', 0.35 ),
				'speedInner' => (float) get_theme_mod( 'cursor_drag_speed_inner', 0.15 )
			],
			'scrollbar' => [ 'speed' => (float) get_theme_mod( 'event_smooth_scrolling_damping', 0.06 ) ],
			'dsn_csrf'  => wp_create_nonce( 'blackdsn-action-post' ),
			'name'      => get_bloginfo( 'name' ),

		) );

	}


	public function enqueue_elementor_preview_scripts() {

		if ( ! blackdsn_is_elementor_preview_mode() ) {
			return;
		}

		wp_enqueue_script( 'blackdsn-elementor-preview', $this->asset_js_plugin() . '/elementor-preview.js', array(),
			self::VERSION, true );
	}


	public function enqueue_elementor_after_editor_scripts() {
		wp_enqueue_script( 'blackdsn-elementor-editor-preview',
			$this->asset_js_plugin() . '/elementor-editor-preview.js', array(), self::VERSION, true );

	}


	public function enqueue_admin_enqueue_scripts( $hook ) {
		if ( ! in_array( $hook, array( 'term.php', 'edit-tags.php', 'post.php', 'post-new.php' ) ) ) {
			return;
		}
		wp_enqueue_style( 'blackdsn-fonts', $this->fontUrl() );
	}

	/**
	 * @return string
	 */
	private function asset(): string {
		return BLACKDSN_DIRECTORY_URI . 'assets';
	}

	/**
	 * @return string
	 */
	private function asset_css(): string {
		return $this->asset() . '/css';
	}

	/**
	 * @return string
	 */
	private function asset_css_plugin(): string {
		return $this->asset_css() . '/plugins';
	}

	/**
	 * @return string
	 */
	private function asset_js(): string {
		return $this->asset() . '/js';
	}

	/**
	 * @return string
	 */
	private function asset_js_plugin(): string {
		return $this->asset_js() . '/plugins';
	}

	private function fontUrl(): string {
		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'swap';
		$fonts[]   = 'Poppins:400,500,600,700';
		if ( $fonts ) {
			$fonts_url = add_query_arg( array(
				'family'  => urlencode( implode( '|', $fonts ) ),
				'display' => urlencode( $subsets ),
			), '//fonts.googleapis.com/css' );
		}

		return $fonts_url;
	}


}

new BlackdsnEnqueue();
