<?php

add_action( 'wp_ajax_nopriv_blackdsn_post_query', 'blackdsn_ajax_post_query' );
add_action( 'wp_ajax_blackdsn_post_query', 'blackdsn_ajax_post_query' );


function blackdsn_ajax_post_query() {

	check_ajax_referer( 'blackdsn-action-post', 'blackdsn_csrf' );


	if ( function_exists( 'blackdsn_get_filter_categories' ) && function_exists( 'blackdsn_shortcode_render_group' ) && class_exists( 'blackdsnShortCode' ) &&
	     isset( $_POST['post_type'] ) && isset( $_POST['paged'] ) && isset( $_POST['posts_per_page'] ) &&
	     is_numeric( $_POST['paged'] ) && is_numeric( $_POST['posts_per_page'] ) &&
	     defined( 'DOING_AJAX' ) && DOING_AJAX ) {


		$post_type = wp_strip_all_tags( $_POST['post_type'] );

		$terms = 'category';
		if ( $post_type === blackdsn_project_slug() ) {
			$terms = blackdsn_category_slug();
		}

		$tax_query = array(
			'relation' => 'OR',
			array(
				'taxonomy' => $post_type === blackdsn_project_slug() ? blackdsn_category_slug() : "category",
				'field'    => 'term_id',
				'terms'    => $_POST['attr']['include_tax'],
				'operator' => wp_strip_all_tags( $_POST['attr']['operator_tax'] )
			),
		);

		$option_query = array(
			'paged'          => wp_strip_all_tags( $_POST['paged'] ),
			'posts_per_page' => wp_strip_all_tags( $_POST['posts_per_page'] ),
			'post_type'      => wp_strip_all_tags( $_POST['post_type'] ),
			'tax_query'      => $tax_query
		);

		$myposts = new WP_Query( $option_query );


		$shortcode = new blackdsnShortCode( array() );
		$shortcode->setBlock( $shortcode->getOptionArray( $_POST, 'attr', array() ) );
		$shortcode->setWidgetBase( blackdsn_base_attr() );


		$encoded = array(
			'status'       => true,
			'filter_array' => blackdsn_get_filter_categories( $myposts, $terms ),
			'html'         => blackdsn_shortcode_render_group( 'post', array( 'widget-base' => $shortcode ), $myposts ),
			'ss'           => $_POST,
			'has_next'     => ( $option_query['posts_per_page'] <= count( $myposts->posts ) ),
		);

		header( 'Content-Type: application/json' );

		echo json_encode( $encoded );
		wp_reset_postdata();

	}

	die();
}
