<?php
/**
 * blackdsn hooks
 *
 * @package blackdsn
 */


add_filter('blackdsn_support_woocommerce_args', function ($args) {
    return array(
        'single_image_width' => 416,
        'thumbnail_image_width' => 1024,
        'product_grid' => array(
            'default_rows' => 4,
            'min_rows' => 1,
            'default_columns' => 3,
            'min_columns' => 1,
            'max_columns' => 6,
        ),
    );
});

/**
 * Change the breadcrumb separator
 */
add_filter('woocommerce_breadcrumb_defaults', function ($defaults){

    $defaults['delimiter'] = ' <span class="delimiter">&nbsp;&#47;&nbsp;</span> ';
    return $defaults;
});



remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
/**
 * Title Product
 */
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);


/**
 * Archive Product
 */

add_action("woocommerce_before_shop_loop", 'blackdsn_grid_list_toggle', 11);

/**
 * Loop
 */
add_action('woocommerce_before_shop_loop_item_title', 'blackdsn_quick_view', 10);
add_action('woocommerce_before_shop_loop_item', 'blackdsn_open_product_image', 10);
add_action('woocommerce_before_shop_loop_item_title', 'blackdsn_close_product_image', 10);
/**
 *  Set product title as link to product page
 **/
add_action('woocommerce_shop_loop_item_title', 'blackdsn_woocommerce_template_loop_product_title', 10);
add_action('woocommerce_shop_loop_item_title', 'woocommerce_template_single_excerpt', 10);


/**
 * Content
 */
add_action('blackdsn_before_shop_loop_item_content', 'blackdsn_open_product_content', 10);
add_action('blackdsn_after_shop_loop_item_content', 'blackdsn_close_product_content', 10);


add_filter('woocommerce_show_page_title', '__return_false');
add_filter('woocommerce_product_description_heading', '__return_false');
add_filter('woocommerce_product_additional_information_heading', '__return_false');
