<?php
/**
 * blackdsn Function
 *
 * @package blackdsn/inc
 */


if (!function_exists('blackdsn_wc_templete')) :

    function blackdsn_wc_templete($slug, array $param = array(), $is_render = false)
    {

        $path = BLACKDSN_DIRECTORY . '/woocommerce/' . $slug . '.php';

        if (!file_exists($path)) {
            return "";
        }

        if (count($param)):
            foreach ($param as $key => $value):
                set_query_var($key, $value);
            endforeach;
        endif;

        if ($is_render):
            ob_start();
        endif;
        extract($param);
        include $path;
        if ($is_render):
            return ob_get_clean();
        endif;

    }

endif;


if (!function_exists('blackdsn_wc_templete_loop')) :
    function blackdsn_wc_templete_loop($slug, array $param = array(), $is_render = false)
    {
        blackdsn_wc_templete('loop/' . $slug, $param, $is_render);
    }

endif;


if (!function_exists('blackdsn_quick_view')) :
    function blackdsn_quick_view()
    {
        blackdsn_wc_templete_loop('quick-view');
    }
endif;

if (!function_exists('blackdsn_open_product_image')) :
    function blackdsn_open_product_image()
    {
        echo '<div class="blackdsn-product-image p-relative overflow-hidden" >';
    }
endif;
if (!function_exists('blackdsn_close_product_image')) :
    function blackdsn_close_product_image()
    {
        echo '</div>';
    }
endif;

if (!function_exists('blackdsn_open_product_content')) :
    function blackdsn_open_product_content()
    {
        echo '<div class="blackdsn-product-content p-relative" >';
    }
endif;
if (!function_exists('blackdsn_close_product_content')) :
    function blackdsn_close_product_content()
    {
        echo '</div>';
    }
endif;


if (!function_exists('blackdsn_grid_list_toggle')) :
    function blackdsn_grid_list_toggle()
    {
        blackdsn_wc_templete_loop('grid-toggle');
    }
endif;


if (!function_exists('blackdsn_woocommerce_template_loop_product_title')) {
    /**
     * Show the product title in the product loop. By default this is an H2.
     */
    function blackdsn_woocommerce_template_loop_product_title()
    {
        global $product;

        $link = apply_filters('woocommerce_template_loop_product_title', get_the_permalink(), $product);
        $class = apply_filters('woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title');

        printf('<a href="%1$s" class="link-view-product" ><h2 class="%2$s">%3$s</h2></a>',
            esc_url($link),
            esc_attr($class),
            get_the_title()
        );// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

    }
}

function blackdsn_percentage_to_sale_badges($post, $product)
{


    if ($product->is_type('variable')) {
        $percentages = array();

        // Get all variation prices
        $prices = $product->get_variation_prices();

        // Loop through variation prices
        foreach ($prices['price'] as $key => $price) {
            // Only on sale variations
            if ($prices['regular_price'][$key] !== $price) {
                // Calculate and set in the array the percentage for each variation on sale
                $percentages[] = round(100 - (floatval($prices['sale_price'][$key]) / floatval($prices['regular_price'][$key]) * 100));
            }
        }
        // We keep the highest value
        $percentage = max($percentages);

    } elseif ($product->is_type('grouped')) {
        $percentages = array();

        // Get all variation prices
        $children_ids = $product->get_children();

        // Loop through variation prices
        foreach ($children_ids as $child_id) {
            $child_product = wc_get_product($child_id);

            $regular_price = (float)$child_product->get_regular_price();
            $sale_price = (float)$child_product->get_sale_price();

            if ($sale_price != 0 || !empty($sale_price)) {
                // Calculate and set in the array the percentage for each child on sale
                $percentages[] = round(100 - ($sale_price / $regular_price * 100));
            }
        }
        // We keep the highest value
        $percentage = max($percentages);

    } else {


        $regular_price = (float)$product->get_regular_price();
        $sale_price = (float)$product->get_sale_price();

        if ($sale_price != 0 || !empty($sale_price)) {
            $percentage = round(100 - ($sale_price / $regular_price * 100));
        } else {
            return '';
        }
    }


    return $percentage;
}

function blackdsn_percentage_to_sale_badge()
{
    global $product;
    if (!$product->is_on_sale()) {
        return;
    }
    if ($product->is_type('simple')) {
        $max_percentage = (($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100;
    } elseif ($product->is_type('variable')) {
        $max_percentage = 0;
        foreach ($product->get_children() as $child_id) {
            $variation = wc_get_product($child_id);
            $price = $variation->get_regular_price();
            $sale = $variation->get_sale_price();
            $percentage = -1;
            if ($price != 0 && !empty($sale)) {
                $percentage = ($price - $sale) / $price * 100;
            }

            if ($percentage > $max_percentage) {
                $max_percentage = $percentage;
            }
        }
    }

    if (isset($max_percentage) && $max_percentage > 0) {
        return round($max_percentage);
    }


    return "";

}


/**
 * Get HTML for a gallery image.
 *
 * Hooks: woocommerce_gallery_thumbnail_size, woocommerce_gallery_image_size and woocommerce_gallery_full_size accept name based image sizes, or an array of width/height values.
 *
 * @param int $attachment_id Attachment ID.
 * @param bool $main_image Is this the main image or a thumbnail?.
 * @return string
 * @since 3.3.2
 */
function blackdsn_get_gallery_image_html($attachment_id, $main_image = false)
{
    $flexslider = (bool)apply_filters('woocommerce_single_product_flexslider_enabled', get_theme_support('wc-product-gallery-slider'));
    $gallery_thumbnail = wc_get_image_size('gallery_thumbnail');
    $thumbnail_size = apply_filters('woocommerce_gallery_thumbnail_size', array($gallery_thumbnail['width'], $gallery_thumbnail['height']));
    $image_size = apply_filters('woocommerce_gallery_image_size', $flexslider || $main_image ? 'woocommerce_single' : $thumbnail_size);
    $full_size = apply_filters('woocommerce_gallery_full_size', apply_filters('woocommerce_product_thumbnails_large_size', 'full'));
    $thumbnail_src = wp_get_attachment_image_src($attachment_id, $thumbnail_size);
    $full_src = wp_get_attachment_image_src($attachment_id, $full_size);
    $alt_text = trim(wp_strip_all_tags(get_post_meta($attachment_id, '_wp_attachment_image_alt', true)));
    $image = wp_get_attachment_image(
        $attachment_id,
        $image_size,
        false,
        apply_filters(
            'woocommerce_gallery_image_html_attachment_image_params',
            array(
                'title' => _wp_specialchars(get_post_field('post_title', $attachment_id), ENT_QUOTES, 'UTF-8', true),
                'data-caption' => _wp_specialchars(get_post_field('post_excerpt', $attachment_id), ENT_QUOTES, 'UTF-8', true),
                'data-src' => esc_url($full_src[0]),
                'data-large_image' => esc_url($full_src[0]),
                'data-large_image_width' => esc_attr($full_src[1]),
                'data-large_image_height' => esc_attr($full_src[2]),
                'class' => esc_attr($main_image ? 'wp-post-image' : ''),
            ),
            $attachment_id,
            $image_size,
            $main_image
        )
    );

    return '<div data-thumb="' . esc_url($thumbnail_src[0]) . '" data-thumb-alt="' . esc_attr($alt_text) . '" class="woocommerce-product-gallery__image"><div data-src="' . esc_url($full_src[0]) . '" data-caption="' . _wp_specialchars(get_post_field('post_excerpt', $attachment_id), ENT_QUOTES, 'UTF-8', true) . '" data-fancybox="_wc-dsn-image">' . $image . '</div></div>';
}