<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( ! class_exists( 'BlackdsnWoocommerce' ) ) :


	class BlackdsnWoocommerce {

		public function __construct() {
			$this->include_files( [
				'template-function',
				'template-hooks',
			] );
			add_action( 'after_setup_theme', array( $this, 'setup' ) );
		}


		/**
		 *
		 * @param $files
		 * @param string $suffix
		 *
		 * @return void
		 */
		public function include_files( $files, $suffix = 'blackdsn-' ) {
			foreach ( $files as $file ) {
				$filepath = BLACKDSN_DIRECTORY . '/inc/classes/woocommerce/inc/' . $suffix . $file . '.php';


				if ( ! file_exists( $filepath ) ) :
					trigger_error( sprintf( esc_html__( 'Error locating %s for inclusion', 'blackdsn' ), $file ), E_USER_ERROR );
				endif;

				require_once $filepath;
			}
			unset( $file, $filepath );
		}


		/**
		 * Sets up theme defaults and registers support for various WooCommerce features.
		 *
		 * Note that this function is hooked into the after_setup_theme hook, which
		 * runs before the init hook. The init hook is too late for some features, such
		 * as indicating support for post thumbnails.
		 *
		 * @return void
		 */
		public function setup() {

			add_theme_support( 'woocommerce', apply_filters( 'blackdsn_support_woocommerce_args', [] ) );

//			add_theme_support( 'wc-product-gallery-zoom' );
//			add_theme_support( 'wc-product-gallery-lightbox' );
			add_theme_support( 'wc-product-gallery-slider' );

		}


	}

	return new BlackdsnWoocommerce();

endif;