<?php

namespace DesignGrid;

class DsnDocElementor {

	private $page_settings_manager, $page_settings_model, $widget_base;

	public function __construct( $post_id = null ) {
		if ( ! class_exists( '\Elementor\Core\Settings\Manager' ) ) {
			return;
		}
		if ( $post_id === null ) {
			$post_id = get_the_ID();
		}

		$this->page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );
		$this->page_settings_model   = $this->page_settings_manager->get_model( $post_id );
		$this->widget_base           = new \DesignGrid\BlackdsnBaseAttr();
	}

	public function getVal( $id, $default = false ) {
		$out = null;
		if ( $this->page_settings_model )
			$out = $this->page_settings_model->get_settings( $id );

		if ( $out !== null )
			return $out;

		return $default;

	}

	public function setVal( $key, $value = null ) {
		if ( $this->page_settings_model )
			$this->page_settings_model->set_settings( $key, $value );
	}

	public function getValTablet( $id, $default = false ) {
		return $this->getVal( $id . '_tablet', $default );
	}

	public function getValMobile( $id, $default = false ) {
		return $this->getVal( $id . '_mobile', $default );
	}


	public function getValueNumber( $id, $default = false ) {

		$size = $this->getVal( $id, [ 'size' => $default ] )['size'];
		if ( ! is_numeric( $size ) ) {
			$size = $default;
		}

		return $size;
	}

	public function getValues() {
		return $this->page_settings_model->get_settings();
	}

	/**
	 * @return BlackdsnBaseAttr |null
	 */
	public function getWidgetBase() {
		if ( ! $this->widget_base )
			$this->widget_base = new \DesignGrid\BlackdsnBaseAttr();

		return $this->widget_base;
	}
}