<?php
/**
 * Custom comment walker for this theme.
 *
 * @package WordPress
 * @subpackage blackdsn
 * @since 1.0.0
 */


if ( !class_exists( 'BlackdsnWalkerComment' ) ) {
    /**
     * CUSTOM COMMENT WALKER
     * A custom walker for comments, based on the walker in blackdsn.
     */
    class BlackdsnWalkerComment extends Walker_Comment
    {

        /**
         * Outputs a comment in the HTML5 format.
         *
         * @param WP_Comment $comment Comment to display.
         * @param int $depth Depth of the current comment.
         * @param array $args An array of arguments.
         *
         * @see https://developer.wordpress.org/reference/functions/get_avatar/
         * @see https://developer.wordpress.org/reference/functions/get_comment_reply_link/
         * @see https://developer.wordpress.org/reference/functions/get_edit_comment_link/
         *
         * @see wp_list_comments()
         * @see https://developer.wordpress.org/reference/functions/get_comment_author_url/
         * @see https://developer.wordpress.org/reference/functions/get_comment_author/
         */

        protected function html5_comment( $comment, $depth, $args )
        {
            $avtar_img = blackdsn_acf_option( 'avetar_img_profile', false, 'user_' . $comment->user_id );
            $auther_comment_url = get_comment_author_url( $comment );


            $comment_class = 'comment-list';
            if ( $depth !== 1 )
                $comment_class = 'comment-list blog_comments-rep';
            switch ( $comment->comment_type ) :
                case 'pingback':
                case 'trackback':
                    ?>

                    <li id="comment-<?php comment_ID(); ?>" class="comment-pingback comment-list comment">
                    <div class="pingback ">
                        <div class="pingback ms-author-name "><?php comment_author_link(); ?></div>
                        <div class="comment-meta">
                            <?php edit_comment_link( '<i class="fas fa-pencil-alt"></i> ' . esc_html__( 'Edit', 'blackdsn' ), '<span class="edit-link">', '</span>' ); ?>
                        </div>
                    </div>


                    <?php break;
                default:
                    ?>
                <li id="comment-<?php comment_ID(); ?>" <?php comment_class( esc_attr( $comment_class ) ); ?> >
                    <div class="comment-body p-relative pt-30">
                        <div class="comment-author p-relative">
                            <?php
                            if ( $avtar_img && wp_attachment_is_image( $avtar_img ) )
                                echo wp_get_attachment_image( $avtar_img );
                            else
                                echo wp_kses_post( get_avatar( $comment, 50, '', '',
                                    array( 'class' => 'p-relative ' )
                                ) );

                            ?>
                        </div>
                        <div class="comment-text">

                            <div class="comment-date fz-16 letter-s1 heading-color">
                                <?php echo get_comment_date( 'F d, Y' ) . esc_html__( ' at ', 'blackdsn' ) . get_comment_time(); ?>
                            </div>
                            <div class="comment-info p-relative d-inline-block">
                                <h6 class="comment-name sm-title-block">
                                    <?php
                                    if ( empty( $auther_comment_url ) ) :
                                        echo esc_html( get_comment_author() );
                                    else:
                                        printf( '<a href="%s" rel="external nofollow" class="url">%s</a>', esc_url( $auther_comment_url ), esc_html( get_comment_author() ) );
                                    endif;
                                    ?>

                                </h6>
                                <?php

                                ?>

                                <?php edit_comment_link( '<i class="fas fa-pencil-alt"></i> ' . esc_html__( 'EDIT', 'blackdsn' ), '<div class="comment-edit p-absolute background-theme heading-color">', '</div>' ); ?>

                            </div>
                            <div class="post-full-content single-post text-holder fz-16">
                                <?php if ( $comment->comment_approved == '0' ): ?>
                                    <i class="moderate">
                                        <?php esc_html_e( 'Your comment is awaiting moderation.', 'blackdsn' ); ?>
                                    </i><br/>
                                <?php endif; ?>
                                <?php comment_text(); ?>
                            </div>
                            <?php
                            comment_reply_link( array_merge( $args, array(
                                'depth' => $depth,
                                'max_depth' => $args[ 'max_depth' ],
                                'reply_text' => '<i class="fas fa-reply"></i> ' . esc_html__( 'REPLY', 'blackdsn' ),
                                'before' => '<div class="reply fz-16 letter-s1 heading-color">',
                                'after' => '</div>',
                            ) ) );
                            ?>

                        </div>
                    </div>

                <?php endswitch;


        }
    }
}


if ( !function_exists( 'blackdsn_post_count_comment' ) ) :

    /**
     * -Retrieves the amount of comments a post has.
     * @return string  - the numeric string representing the number of comments  the post has
     */
    function blackdsn_post_count_comment( $link = true, $in_h3 = '', $show_num = true )
    {
        $comment_num = get_comments_number();
        $s_link_open = '<a href="' . esc_url( get_comments_link() ) . '">';
        $s_link_close = '</a>';
        $comment = '';
        $s_title = '' . $in_h3;
        $e_title = '';
        $s_number = '<span class="num-comment">';
        $e_number = '</span>';

        // comment link
        if ( $show_num ):
            if ( $comment_num == 0 ):
                $comment = $s_title . esc_html__( 'Comment', 'blackdsn' ) . $e_title . $s_number . '0' . $e_number;
                $s_link_open = '';
                $s_link_close = '';
            elseif ( $comment_num > 1 ) :
                $comment = $s_title . esc_html__( 'Comments', 'blackdsn' ) . $e_title . $s_number . esc_html( $comment_num ) . $e_number;
            else:
                $comment = $s_title . esc_html__( 'Comment', 'blackdsn' ) . $e_title . $s_number . esc_html( $comment_num ) . $e_number;
            endif;
        else:
            if ( $comment_num > 0 ):
                $comment = $s_title . esc_html__( 'Comments', 'blackdsn' ) . $e_title;
            else:
                $comment = $s_title . esc_html__( 'No Comments', 'blackdsn' ) . $e_title;
            endif;

        endif;


        if ( $link ):
            $comments = $s_link_open . $comment . $s_link_close;
        else:
            $comments = $comment;
        endif;


        return $comments;
    }

endif;