<?php

abstract class BlackdsnTemplate {

	const VERSION = '1.0.0';
	private $category = [];
	private $template = [];

	public function __construct() {
		add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'after_enqueue_scripts' ] );
		add_action( 'wp_ajax_nopriv_blackdsn_temp', [ $this, 'blackdsn_ajax_temp' ] );
		add_action( 'wp_ajax_blackdsn_temp', [ $this, 'blackdsn_ajax_temp' ] );
		add_action( 'blackdsn_template', [ $this, 'blackdsn_template' ] );
		add_action( 'blackdsn_template_category', [ $this, 'blackdsn_template_category' ] );
		add_action( "admin_init", function () {
			add_action( 'elementor/editor/footer', [ $this, 'print_template_views' ] );
		}, 99 );

	}


	abstract public function print_template_views();

	public function after_enqueue_scripts() {
		wp_enqueue_script( 'isotope', BLACKDSN_DIRECTORY_URI . 'assets/js/plugins/isotope.min.js', array( 'jquery' ),
			'3.0.6', true );

		wp_enqueue_script( 'blackdsn-elementor-editor-preview-template',
			BLACKDSN_DIRECTORY_URI . 'assets/js/plugins/elementor-editor-preview-template.min.js', array( 'jquery' ),
			self::VERSION,
			true );

		$this->enqueue_scripts();

		wp_enqueue_style( 'blackdsn-elementor-editor-preview-template',
			BLACKDSN_DIRECTORY_URI . 'assets/css/template.css', array(), self::VERSION );

		wp_localize_script( 'blackdsn-elementor-editor-preview-template', 'dsnTempParam', array(
			'queries'       => esc_url( admin_url( 'admin-ajax.php?action=blackdsn_temp' ) ),
			'dsn_temp_csrf' => wp_create_nonce( 'blackdsn-action-temp' )
		) );
	}

	protected function enqueue_scripts() {

	}

	public function blackdsn_template( array $args = [] ) {
		$this->template = array_merge( $this->template, $args );
	}

	public function blackdsn_template_category( array $args = [] ) {
		$this->category = array_merge( $this->category, $args );
	}

	/**
	 * @return array
	 */
	public function get_category(): array {
		return $this->category;
	}

	/**
	 * @return array
	 */
	public function get_template(): array {
		return $this->template;
	}

	abstract public function get_json( $name );

	public function blackdsn_ajax_temp() {

		check_ajax_referer( 'blackdsn-action-temp', 'dsn_temp_csrf' );

		if ( isset( $_POST['name'] ) && defined( 'DOING_AJAX' ) && DOING_AJAX ) {

			$name = wp_strip_all_tags( $_POST['name'] );
			$s    = $this->get_json( $name );

			if ( ! $s ) :
				$encoded = array(
					'status' => false,
				);
			else :

				if ( isset( $s['content'] ) && is_array( $s['content'] ) )
					foreach ( $s['content'] as $index => $item ):
						$s['content'][ $index ]['id'] = $this->generateRandomString( strlen( $item['id'] ) );
					endforeach;

				$encoded = array(
					'status' => true,
					'data'   => $s,

				);
			endif;

			header( 'Content-Type: application/json' );

			echo json_encode( $encoded );

		} else {
			header( 'Content-Type: application/json' );

			echo json_encode( [
				'status' => false,
				'error'  => "Check Data ",
			] );
		}

		die();
	}


	private function generateRandomString( $length = 8 ) {
		return substr( str_shuffle( str_repeat( $x = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',
			ceil( $length / strlen( $x ) ) ) ), 1, $length );
	}
}