<?php


namespace DesignGrid;


class BlackdsnOption
{


    const PRODUCT_CATEGORY = "product_cat";
    const PRODUCT_TAG = "product_tag";


    /**
     * @param string $seperate
     * @param false $terms
     * @param bool $link
     * @param false $current_post
     * @param string $after
     * @param string $before
     *
     * @return string
     */
    public static function PostCategory($seperate = ', ', $terms = false, $link = true, $current_post = false, $after = '', $before = '')
    {

        if ($terms === false) {
            $terms = 'category';
            if (blackdsn_is_work($current_post)) {
                $terms = blackdsn_category_slug();
            }
        }

        $categores = get_the_terms($current_post, $terms);
        $outPut = '';
        $i = 0;
        if (!empty($categores)) {
            foreach ($categores as $cat) {
                $cat_link = get_category_link($cat->term_id);
                $alt = esc_attr__('View All Posts in', 'blackdsn') . ' ' . $cat->description;
                $cat_name = $cat->name;

                if ($i > 0 && !$link) {
                    $outPut .= $seperate;
                }

                $outPut .= $after;

                if ($link) {
                    $s = $seperate;
                    if ($i === count($categores) - 1) {
                        $s = '';
                    }
                    $outPut .= '<a href="' . esc_url($cat_link) . '" title="' . esc_attr($alt) . '" class="effect-ajax">' . esc_html($cat_name) . $s . '</a>';
                } else {
                    $outPut .= esc_html($cat_name);
                }

                $outPut .= $before;
                $i++;
            }

        }

        return $outPut;
    }

    /**
     * @param bool $isHeader
     * @param string $default
     * @param string $id
     *
     * @return false
     */
    public static function layoutPages($isHeader = true, $default = 'container', $id = 'page_layout')
    {

        if (is_404()) {
            return false;
        }

        if (is_404()) {
            $default = 'full';
        }


        if (is_home() || (is_archive() && !blackdsn_is_shop()) || is_search()) {
            $layout = 'container';
        } else {
            $layout = blackdsn_get_option_pages($id, $default, blackdsn_get_id_shop());
        }


        if ($layout !== 'full') {
            $isHalf = $layout === 'half';
            if ($isHeader):
                echo self::layoutHeader($isHalf);
            else :
                echo self::layoutFooter($isHalf);
            endif;
        }

    }


    /**
     * @param bool $isHalf
     *
     * @return string
     */
    public static function layoutHeader($isHalf = true)
    {
        $out = '<section class="page-content ">';
        $out .= '<div class="container">';
        if ($isHalf):
            $out .= '<div class="row justify-content-center">';
            $out .= '<div class="col-lg-10">';
        endif;

        return $out;
    }


    /**
     * @param bool $isHalf
     *
     * @return string
     */
    public static function layoutFooter($isHalf = true)
    {
        $out = '';
        if ($isHalf):
            $out .= '</div><!--close col-lg-10-->';
            $out .= '</div><!--close row-->';
        endif;
        $out .= '</div><!--close container-->';
        $out .= '</section><!--close Section-->';


        return $out;
    }

    /**
     * @return string
     */
    public static function dateLink()
    {
        $archive_year = get_the_time('Y');
        $archive_month = get_the_time('m');
        $archive_day = get_the_time('d');

        return get_day_link($archive_year, $archive_month, $archive_day);
    }

    /**
     * @param string $args
     * @param string $class
     */
    public static function Pagination($args = '', $class = '')
    {
        global $wp_query;

        $num = blackdsn_get_option_array($args, 'total', 0);

        if ($wp_query->max_num_pages > 1 || $num > 1) {
            $out = '<div class="type-p-nav">';
            $out .= '<div class="dsn-pagination  p-relative d-flex ' . $class . '">';
            $out .= paginate_links($args);
            $out .= '</div>';
            $out .= '</div>';
        }

        echo isset($out) ? $out : '';

    }


    /**
     * @param string $seperate
     * @param string $classes
     *
     * @return string
     */
    public static function postTag($seperate = ', ', $classes = '')
    {

        $tags = get_the_tags();

        $outPut = '';
        $i = 0;

        if (!empty($tags)) {
            $outPut .= '<div class="post-tags p-relative heading-color font-heading">';
            foreach ($tags as $tag) {
                $tag_link = get_tag_link($tag->term_id);
                $alt = esc_attr__('View All Posts in Tag', 'blackdsn') . ' ' . $tag->description;
                $tag_name = $tag->name;
                $post_meta = $tag->taxonomy;

                if ($i > 0) {
                    $outPut .= $seperate;
                }

                $outPut .= '<a class="' . esc_attr($classes) . '" href="' . esc_url($tag_link) . '" title="' . esc_attr($alt) . '" rel="tag"><span class="post_tag ' . esc_attr($post_meta) . '">' . esc_html($tag_name) . '</span></a>';
                $i++;
            }
            $outPut .= '</div>';
        }

        return $outPut;
    }


    public static function PostCategorySlug($terms = false, $current_post = false)
    {

        if ($terms === false) {
            $terms = 'category';
            if (blackdsn_is_work($current_post)) {
                $terms = blackdsn_category_slug();
            }
        }

        $categores = get_the_terms($current_post, $terms);
        $outPut = '';
        $i = 0;
        if (!empty($categores)) {
            foreach ($categores as $cat) {
                if ($i > 0) {
                    $outPut .= ' ';
                }
                $outPut .= esc_attr($cat->slug);

                $i++;
            }

        }

        return $outPut;
    }


    /**
     * @param array|string $args
     */
    public static function getTermsArray($args = array(), $key = "slug"): array
    {
        $terms = get_terms($args);
        $out = [];
//        if (!empty($args))
            foreach ($terms as $term):
                $out[$term->{$key}] = $term->name;
            endforeach;


        return $out;
    }

}