<!doctype html>
<html <?php language_attributes(); ?> >

<head>
    <meta charset="<?php bloginfo( 'charset' ) ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
    <link rel="profile" href="<?php echo is_ssl() ? 'https' : 'http' ?>://gmpg.org/xfn/11">
	<?php
	if ( is_singular() && pings_open( get_queried_object() ) ): ?>
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif;
	wp_head();
	?>


</head>

<body <?php body_class(); ?>>
<?php
if ( function_exists( 'wp_body_open' ) ) {
	wp_body_open();
}
blackdsn_get_template_header( 'preloader' );
?>
<main id="main_root" class="main-root">
	<?php blackdsn_get_template_header( 'site', 'header' ); ?>
    
    <div id="dsn-scrollbar">
		<?php blackdsn_get_template_header( 'header' ); ?>
        <div id="page_wrapper" class="wrapper <?php echo esc_attr( blackdsn_get_layout_page() ) ?>">