<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Blackdsn
 *
 */


define( 'BLACKDSN_THEME_SLUG', 'blackdsn' );

define( 'BLACKDSN_DIRECTORY', trailingslashit( get_template_directory() ) );
define( 'BLACKDSN_DIRECTORY_URI', trailingslashit( get_template_directory_uri() ) );


if ( is_admin() ):
	/**
	 * Include the TGM_Plugin_Activation class.
	 */
	require_once BLACKDSN_DIRECTORY . '/inc/classes/class-tgm-plugin-activation.php';

	/**
	 *  Registers theme support for a given feature.
	 */
	require_once BLACKDSN_DIRECTORY . '/inc/function-required-plugins.php';
endif;


require_once BLACKDSN_DIRECTORY . '/inc/classes/BlackdsnBaseAttr.php';
require_once BLACKDSN_DIRECTORY . '/inc/classes/woocommerce/BlackdsnWoocommerce.php';


/**
 * The Primary Page navBar
 */
require_once BLACKDSN_DIRECTORY . '/inc/function-nav.php';


/**
 * Custom comment walker for this theme.
 */
require_once BLACKDSN_DIRECTORY . '/inc/classes/BlackdsnWalkerComment.php';


/**
 *  Registers theme support for a given feature.
 */
require_once BLACKDSN_DIRECTORY . '/inc/function-theme-support.php';


require_once BLACKDSN_DIRECTORY . 'inc/options/wc-helper.php';
require_once BLACKDSN_DIRECTORY . 'inc/options/pages.php';
require_once BLACKDSN_DIRECTORY . '/inc/function-helpers.php';

require_once BLACKDSN_DIRECTORY . '/inc/classes/BlackdsnOption.php';


/**
 *
 * - functions and definitions
 */

require_once BLACKDSN_DIRECTORY . 'inc/classes/DsnDocElementor.php';

/**
 *
 * - End  functions and definitions
 */


/**
 * Registers the script if $src provided (does NOT overwrite), and enqueues it.
 */
require_once BLACKDSN_DIRECTORY . '/inc/function-enqueue.php';

require_once BLACKDSN_DIRECTORY . '/inc/function-filter.php';

require_once BLACKDSN_DIRECTORY . '/inc/function-widget.php';

require_once BLACKDSN_DIRECTORY . '/inc/function-ajax.php';


//if (is_admin()):
//
//    /**
//     * Merlin WP
//     * Load only if One Click Demo Import plugin
//     * is not activated
//     */
//    if (!class_exists('OCDI_Plugin')) {
//        require_once BLACKDSN_DIRECTORY . '/inc/merlin/vendor/autoload.php';
//        require_once BLACKDSN_DIRECTORY . '/inc/merlin/class-merlin.php';
//        require_once BLACKDSN_DIRECTORY . '/inc/merlin/merlin-config.php';
//    }
//
//
//    require_once BLACKDSN_DIRECTORY . '/inc/merlin/merlin-filters.php';
//
//endif;




