<?php

if ( post_password_required() ):
	return;
endif;
?>
<div id="comment_post" class="comments-post p-relative mt-section">

    <div class="comments-area p-relative  mb-section">


		<?php if ( $titleComment = blackdsn_post_count_comment( false, '', false ) ): ?>


            <h4 class="comments-title title-block border-section-bottom">
				<?php echo esc_html( $titleComment ); ?>
            </h4>


		<?php endif;

		if ( have_comments() ) :
			echo '<ol class="comment-list">';
			wp_list_comments( array(
				'walker'      => new BlackdsnWalkerComment(),
				'type'        => 'all',
				'style'       => 'ol',
				'avatar_size' => 120,

			) );

			$comment_pagination = paginate_comments_links(
				array(
					'echo'      => false,
					'end_size'  => 0,
					'mid_size'  => 0,
					'next_text' => esc_html__( 'Nouveaux commentaires', 'blackdsn' ) . ' <span aria-hidden="true">&rarr;</span>',
					'prev_text' => '<span aria-hidden="true">&larr;</span> ' . esc_html__( 'Anciens commentaires', 'blackdsn' ),
				)
			);

			if ( $comment_pagination ) {
				$pagination_classes = '';

				// If we're only showing the "Next" link, add a class indicating so.
				if ( strpos( $comment_pagination, 'prev page-numbers' ) === false ) {
					$pagination_classes = ' only-next';
				}
				?>

                <nav class="comments-pagination pagination<?php echo esc_attr( $pagination_classes ); ?>"
                     aria-label="<?php esc_attr_e( 'Commentaires', 'blackdsn' ); ?>">
					<?php echo wp_kses_post( $comment_pagination ); ?>
                </nav>

				<?php
			}

			echo '</ol>';

		endif;

		/* If comments are closed and there are comments, let's leave a little note, shall we? */
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
			printf( '<div class="mt-section">%s</div>', esc_html__( 'Les commentaires sont fermés', 'blackdsn' ) );
		endif;


		?>


    </div>


	<?php
	$commenter = wp_get_current_commenter();

	$rowstart    = '<div class="entry-form p-relative mb-30">';
	$rowText     = '<div class="entry-form p-relative">';
	$rowend      = '</div>';
	$autor       = '<input id="author" name="author" type="text" placeholder="' . esc_attr__( 'Entrez votre nom ...', 'blackdsn' ) . '"  value="' . esc_attr( $commenter['comment_author'] ) . '" maxlength="245" required>';
	$email       = '<input id="email"  name="email" type="email" placeholder="' . esc_attr__( 'Entrez votre email ...', 'blackdsn' ) . '" value="' . esc_attr( $commenter['comment_author_email'] ) . '" maxlength="245" required>';
	$url       = '<input   name="url" type="text" placeholder="' . esc_attr__( 'Entrez votre site web ...', 'blackdsn' ) . '" value="' . esc_attr( $commenter['comment_author_url'] ) . '" maxlength="245" >';
	$textComment = $rowstart . '<textarea id="comment" name="comment" rows="6" placeholder="' . esc_attr__( 'Commentaire', 'blackdsn' ) . '" required="required"></textarea>' . $rowend;


	$fields = array(
		'author' => '<div class="row"><div class="col-md-4">' . $rowstart . $autor . $rowend . '</div>',
		'email'  => '<div class="col-md-4">' . $rowstart . $email . $rowend . '</div>',
		'url'  => '<div class="col-md-4">' . $rowstart . $url . $rowend . '</div></div>',
	);

	$commenter_args_form = array(
		'class_form'           => 'dsn_root_form dsn-form-comment',
		'label_submit'         => esc_html__( 'Postez un commentaire', 'blackdsn' ),
		'title_reply'          => esc_html__( 'Laissez un commentaire', 'blackdsn' ),
		'title_reply_before'   => ' <h4 class="comments-title p-relative title-block line-shap line-shap-before">',
		'title_reply_after'    => '</h4>',
		'cancel_reply_before'  => '',
		'cancel_reply_after'   => '',
		'title_reply_to'       => esc_html__( 'Laissez une réponse à', 'blackdsn' ) . ' %s',
		'cancel_reply_link'    => '<span class="dsn-cancel-comment p-absolute background-theme-color">' . esc_html__( 'CANCEL', 'blackdsn' ) . '</span>',
		'class_submit'         => 'dsn-button-comment submit-form ',
		'fields'               => $fields,
		'comment_field'        => $textComment,
		'comment_notes_before' => '',
		'comment_notes_after'  => '',
		'submit_field'         => '<div class="submit-div image-zoom" data-dsn="parallax"> %1$s %2$s</div>',
		'format'               => 'xhtml',
	);
	?>


    <div class="comments-form ">
		<?php comment_form( $commenter_args_form ) ?>
    </div>
</div>