<?php
get_header();

$img     = get_theme_mod( '404_bg_image', BLACKDSN_DIRECTORY_URI . 'assets/img/404.jpg' );
$overlay = get_theme_mod( 'overlay_404', 6 );

$widget = blackdsn_base_attr();

$widget->add_render_attribute( 'cover-bg', [
	'class'        => 'glitch__img cover-bg z-index-0 w-100 h-100',
	'style'        => sprintf( 'background-image : url(%s);', esc_url( $img ) ),
	'data-overlay' => esc_attr( $overlay )
] )


?>
    <header class="dsn-header-hero error404 p-relative v-dark-head background-main">
        <div class="dsn-parallax-move-img w-100 h-100 p-absolute">

            <div class="hero-img w-100 h-100 full-width">
                <div <?php $widget->print_render_attribute_string( 'cover-bg' ); ?>></div>
            </div>

        </div>
        <div class="container v-middle">
            <div class="row justify-content-center align-items-center h-100">
                <div class="col-md-8">
                    <div class="header-content mb-60 text-center">
                        <div class="name-title justify-content-center ">
                            <h1 class="title title-error">
                                    <span class="title-auto-break">
                                        <?php esc_html_e( '404', 'blackdsn' ) ?>
                                    </span>
                            </h1>
                        </div>
                        <h4 class="sm-title-block text-center text-capitalize">
                            <span>
                                <?php
                                esc_html_e( 'On dirait que rien n’a été trouvé à cet endroit. Essayez peut-être une recherche ? ', 'blackdsn' );
                                ?>
                            </span>
                        </h4>

                        <div class="form-search max-w570">
	                        <?php get_search_form(); ?>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </header>
<?php get_footer(); ?>