<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget      = $shortcode->getWidgetBase();
$title       = $shortcode->getVal( 'title' );
$description = $shortcode->getVal( 'description' );

if ( ! $title && ! $description ) {
	return;
}


$description_before = '';
$description_after  = '';

$size     = $shortcode->getSize();
$html_tag = $shortcode->getHtmlTag();


$line_text = $shortcode->getLinetext();


if ( $size ) {
	$widget->add_render_attribute( 'title', 'class', $size );
}


$widget->add_render_attribute( 'section-title', 'class', [
	'section-title d-flex',
	$shortcode->getVal( 'space_section', 'mb-70' ),
] );


$widget->add_render_attribute( 'title', 'class', [
	'dsn-heading-title p-relative',
	$shortcode->getVal( 'dsn_title_animate', '' ),
	$shortcode->getVal( 'title_color' ),

] );

$widget->add_render_attribute( 'description', 'class', [
	'description d-inline-block p-relative mb-10 border-section-bottom',
	$shortcode->getVal( 'dsn_description_animate', '' ),
	$shortcode->getVal( 'description_color' ),
] );


if ( $title ) {
	$title = sprintf( '<%1$s %2$s>%3$s</%1$s>', $html_tag, $widget->get_render_attribute_string( 'title' ), $title );
}

$description_before = sprintf( '<p %1$s>%2$s</p>', $widget->get_render_attribute_string( 'description' ), $description );


printf( '<div %1$s> <div class="sub-section-title "> %2$s %3$s  </div></div>', $widget->get_render_attribute_string( 'section-title' ), $description_before, $title );