<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget      = $shortcode->getWidgetBase();
$title       = $shortcode->getVal( 'title' );
$description = $shortcode->getVal( 'description' );
$direction   = $shortcode->getVal( 'direction', '1' );

if ( ! $title && ! $description ) {
	return;
}


$description_before = '';
$description_after  = '';

$size      = $shortcode->getSize();
$html_tag  = $shortcode->getHtmlTag();
$line_text = $shortcode->getLinetext();

$line_text_into = $shortcode->getVal( 'dsn_line_title_into' );


$line_text = $shortcode->getLinetext();


if ( $size ) {
	$widget->add_render_attribute( 'title', 'class', $size );
}

if ( $line_text ) {
	$widget->add_render_attribute( 'title', 'class', $line_text );
}
if ( $line_text_into ) {
	$widget->add_render_attribute( 'span_title', 'class', $line_text_into );
}


$widget->add_render_attribute( 'section-title', 'class', [
	'section-title d-flex  ',
	$shortcode->getVal( 'space_section', 'mb-70' )
] );


$widget->add_render_attribute( 'title', 'class', [
	'dsn-heading-title p-relative title-block-lg d-block',
	$shortcode->getVal( 'dsn_title_animate', '' ),
	$shortcode->getVal( 'use_as_stroke' ),
	$shortcode->getVal( 'dsn_line_title' ),
	$shortcode->getVal( 'title_color' ),

] );

$widget->add_render_attribute( 'description', 'class', [
	'description d-inline-block p-relative',
	$shortcode->getVal( 'dsn_description_animate', '' ),
	$shortcode->getVal( 'dsn_line_description', 'line-shape line-shape-before' ),
	$shortcode->getVal( 'description_color' ),
] );


$widget->add_render_attribute( 'span_description', 'class', $shortcode->getVal( 'dsn_line_description_into', 'line-bg-right' ) );


if ( $title ) {
	$title = sprintf( '<%1$s %2$s><span %3$s>%4$s</span></%1$s>', $html_tag, $widget->get_render_attribute_string( 'title' ), $widget->get_render_attribute_string( 'span_title' ), $title );
}

if ( $description ) {
	if ( $direction ) {
		$widget->add_render_attribute( 'description', 'class', 'mb-10' );
		$description_before = sprintf( '<p %1$s><span %2$s>%3$s</span></p>', $widget->get_render_attribute_string( 'description' ), $widget->get_render_attribute_string( 'span_description' ), $description );
	} else {
		$widget->add_render_attribute( 'description', 'class', 'mt-10' );
		$description_after = sprintf( '<p %1$s><span %2$s>%3$s</span></p>', $widget->get_render_attribute_string( 'description' ), $widget->get_render_attribute_string( 'span_description' ), $description );
	}
}


printf( '<div %1$s> <div class="sub-section-title "> %2$s %3$s %4$s </div></div>', $widget->get_render_attribute_string( 'section-title' ), $description_before,$title, $description_after );