<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content', array() );


$shortcode = new blackdsnShortCode( $attr, $items_key );


$items = $shortcode->getVal( 'items', array() );

if ( ! count( $items ) || ! is_array( $items ) ) {
	return;
}


$widget = $shortcode->getWidgetBase();

/**
 * testimonials
 */
$widget->add_render_attribute( 'testimonials', [
	'class'           => 'dsn-testimonials blackdsn-swiper-slider dsn-swiper p-relative has-parallax-image',
	'data-dsn-option' => json_encode( $shortcode->getSwiperOption() )
] );

/**
 * testimonials-content
 */
$widget->add_render_attribute( 'swiper-slide', [
	'class' => [
		'swiper-slide',
		$shortcode->getVal( 'bg_ver_item', '' ),
		$shortcode->getVal( 'bg_item', 'background-transparent' )
	]
] );


$widget->add_render_attribute( 'box-text', 'class', 'label box-text' );
$shortcode->add_parallax_attributes( 'box-text', 'content' );

$widget->add_render_attribute( 'image', 'class', 'avatar box-img dsn-auto' );
$shortcode->add_parallax_attributes( 'image', 'image' );


$widget->add_render_attribute( 'quote', 'class', 'quote' );
$shortcode->add_parallax_attributes( 'quote', 'description' );


?>

<div <?php $widget->print_render_attribute_string( 'testimonials' ) ?>>

    <div class="testimonials-content">


        <div class="testimonial-inner">
			<?php echo blackdsnSvg::QUOTE; ?>
            <div class="swiper">
                <div class="swiper-wrapper">
					<?php foreach ( $items as $index => $item ) : $shortcode->setSubBlock( $item );
						$image = $shortcode->getAttachImage( $shortcode->getSubVal( 'image' ),
							$shortcode->getVal( 'image_size', 'thumbnail' ), array( 'class' => 'cover-bg-img' ) )
						?>
                        <div <?php $widget->print_render_attribute_string( 'swiper-slide' ) ?> >
							<?php
							if ( $image ) {
								printf( '<div %s>%s</div>', $widget->get_render_attribute_string( 'image' ), $image );
							}
							?>
                            <div class="testimonial-item">

                                <div class="testimonial-content mb-25">

									<?php
									echo blackdsn_shortcode_render( 'testimonial/content/subtitle', $shortcode, [
										'index' => $index
									] );
									echo blackdsn_shortcode_render( 'testimonial/content/description', $shortcode, [
										'index' => $index
									] );
									?>
                                </div>
                                <div class="content-inner border-top">
                                    <div class="d-flex align-items-center ">
										<?php

										if ( $image ) {
											printf( '<div %s>%s</div>', $widget->get_render_attribute_string( 'image' ),
												$image );
										}

										if ( $name = $shortcode->getSubVal( 'name', 'The Name' ) ) {
											$name_key = $shortcode->getItemKey( 'name', $index );
											$widget->add_render_attribute( $name_key, 'class',
												'testimonial-name sm-title-block' );
											$name = sprintf( '<h4 %s>%s</h4>',
												$widget->get_render_attribute_string( $name_key ), $name );
										}


										if ( $position = $shortcode->getSubVal( 'position', 'The Position' ) ) {
											$position_key = $shortcode->getItemKey( 'position', $index );
											$widget->add_render_attribute( $position_key, 'class',
												'testimonial-position' );
											$position = sprintf( '<h5 %s>%s</h5>',
												$widget->get_render_attribute_string( $position_key ), $position );
										}

										if ( $name || $position ) {
											printf( '<div %s>%s</div>',
												$widget->get_render_attribute_string( 'box-text' ), $name . $position );
										}

										?>

                                    </div>
                                </div>

                            </div>

                        </div>
					<?php endforeach; ?>
                </div>
            </div>
        </div>

		<?php $shortcode->print_content_paginate_render(); ?>
    </div>
</div>
