<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content', array() );


$shortcode = new blackdsnShortCode( $attr, $items_key );


$items = $shortcode->getVal( 'items', array() );

if ( ! count( $items ) || ! is_array( $items ) ) {
	return;
}

$widget = $shortcode->getWidgetBase();

$bg_ver_btn = $shortcode->getVal( 'bg_ver_btn', '' );
$bg_btn     = $shortcode->getVal( 'bg_btn', 'background-transparent' );


$widget->add_render_attribute( 'team-item', 'class', [ 'team-item p-relative grid-item box-hover-image' ] );
$widget->add_render_attribute( 'team-item', $shortcode->get_render_swiper_slide_attribute() );


$widget->add_render_attribute( 'team-item-inner', 'class', [
	'team-item-inner',
	$shortcode->getVal( 'bg_ver_btn', '' ),
	$shortcode->getVal( 'bg_btn', 'background-section' )
] );
$shortcode->add_parallax_attributes( 'team-item-inner', 'content' );


?>


<?php
foreach ( $items as $index => $item ) :
	$shortcode->setSubBlock( $item );


	$image = $shortcode->getAttachImage( $shortcode->getSubVal( 'image' ), $shortcode->getVal( 'image_size' ), [ 'class' => 'cover-bg-img' ] );


	$li = '';

	for ( $x = 1; $x <= 5; $x ++ ):
		$link      = $shortcode->getSubVal( 'link_social_' . $x );
		$text_link = $shortcode->getSubVal( 'icon_' . $x );
		if ( $text_link ) {
			$li .= sprintf( '<li ><a href="%1$s" target="_blank" rel="nofollow" class="init-color">%2$s<span>%3$s</span></a></li>',
				$link,
				$shortcode->getIcon( $shortcode->getSubVal( 'icon-' . $x ) ),
				$text_link
			);
		}
	endfor;

	?>
    <div <?php $widget->print_render_attribute_string( 'team-item' ) ?> >
        <div <?php $widget->print_render_attribute_string( 'team-item-inner' ) ?> >


			<?php if ( $image ) {
				printf( '<div class="avatar box-img" data-overlay="4">%s</div>', $image );
			} ?>

            <div class="team-content border-before text-center">
				<?php


				if ( $name = $shortcode->getSubVal( 'name', 'The Name' ) ) {
					$name_key = $shortcode->getItemKey( 'name', $index );
					$widget->add_render_attribute( $name_key, 'class', 'text-name sm-title-block' );
					printf( '<h4 %s>%s</h4>', $widget->get_render_attribute_string( $name_key ), $name );
				}

				if ( $position = $shortcode->getSubVal( 'position', 'The Position' ) ) {
					$position_key = $shortcode->getItemKey( 'position', $index );
					$widget->add_render_attribute( $position_key, 'class', 'text-position' );
					printf( '<span %s>%s</span>', $widget->get_render_attribute_string( $position_key ), $position );
				}
				if ( $li ) {
					printf( '<ul class="team-socials dsn-socials box-social">%s</ul>', $li );
				}

				?>
            </div>


        </div>
    </div>
<?php


endforeach;
?>

