<?php
$attr = get_query_var( 'attr' );


$shortcode = new blackdsnShortCode( $attr );

$shortcode->set_items( get_query_var( 'content', [] ) );

$widget = $shortcode->getWidgetBase();

$items     = $shortcode->getVal( 'items' );
$title_tag = $shortcode->getVal( 'title_tag', 'h1' );


if ( ! count( $items ) )
	return '';

?>

<div class="dsn-tabs p-relative over-hidden " role="tablist">
    <div class="tabs">
        <div class="tabs__button mb-30" role="tablist">
            <ul class="d-flex flex-wrap justify-content-center">

				<?php foreach ( $items as $index => $item ):

					$shortcode->setSubBlock( $item );
					$ren_title = $shortcode->getItemKey( 'title', $index );
					$title     = $shortcode->getSubVal( 'title', esc_html__( 'Enter Title', 'blackdsn' ) );
					$widget->add_render_attribute( $ren_title, [
						'id'       => 'tab-' . $index . $shortcode->getSubVal( '_id', '' ),
						'class'    => 'link-click h6 ',
						'role'     => 'tab',
						'data-tab' => $index,
					] );
					if ( $index === 0 )
						$widget->add_render_attribute( $ren_title, 'class', 'active' );
					printf( '<li %1$s>%2$s</li>', $widget->get_render_attribute_string( $ren_title ), $title )
					?>

				<?php endforeach; ?>
            </ul>
        </div>

        <div class="tabs__content text-center">
			<?php foreach ( $items as $index => $item ):
				$shortcode->setSubBlock( $item );
				$ren_description = $shortcode->getItemKey( 'description', $index );
				$ren_description = $shortcode->getItemKey( 'description', $index );
				$description     = $shortcode->getSubVal( 'description' );
				$widget->add_render_attribute( $ren_description, 'class', 'dsn-description' );

				$ren_tab = $shortcode->getItemKey( 'description_tab', $index );
				$widget->add_render_attribute( $ren_tab, [
					'id'    => 'tab-' . $index . $shortcode->getSubVal( '_id', '' ) . '-content',
					'class' => 'tabs__item p-relative'
				] );

				if ( $index !== 0 )
					$widget->add_render_attribute( $ren_tab, 'style', 'display:none;' );


				?>
                <div <?php $widget->print_render_attribute_string( $ren_tab ) ?> >
					<?php
					if ( $description )
						printf( '<div %s>%s</div>', $widget->get_render_attribute_string( $ren_description ), $description );
					?>
                </div>
			<?php endforeach; ?>


        </div>
    </div>
</div>
