<?php

/**
 * @var $shortcode \blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$option    = get_query_var( 'content' );


$widget = $shortcode->getWidgetBase();

$title = $shortcode->getSubVal( 'post_title' );


$title_tag = $shortcode->getItemKey( 'title_tag', $option['index'] );
$widget->add_render_attribute( $title_tag, [ 'class' => 'title has-box-mod p-relative' ] );

$tag_link = $shortcode->getItemKey( 'post_title', $option['index'] );
$widget->add_render_attribute( $tag_link, 'data-dsn-split', 'chars' );
$widget->add_render_attribute( $tag_link, 'class', 'init-color' );


if ( $option['link_with_title'] ):
	if ( $shortcode->getVal( 'dsn_views' ) ):
		$widget->add_link_attributes( $tag_link, $shortcode->getSubVal( 'link', array() ) );
	else:
		$widget->add_render_attribute( $tag_link, [
			'href'          => get_the_permalink( $shortcode->getSubVal( 'ID' ) ),
			'class'         => 'effect-ajax',
			'data-dsn-ajax' => 'slider',
		] );
	endif;
	$title = sprintf( '<a %s>%s</a>', $widget->get_render_attribute_string( $tag_link ), $title );
else:
	$title = sprintf( '<div %s>%s</div>', $widget->get_render_attribute_string( $tag_link ), $title );
endif;


printf( '<%1$s %2$s>%3$s</%1$s>', $shortcode->getHtmlTag(), $widget->get_render_attribute_string( $title_tag ), $title );