<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();

$effect_slider = $shortcode->getVal( 'effect_slider' );


if ( $effect_slider === 'dsn-webgl' )
	$option = [
		'direction'           => $shortcode->getVal( 'direction_webgl', 'horizontal' ),
		'allowTouchMove'      => boolval( $shortcode->getVal( 'allowTouchMove', '1' ) ),
		'watchSlidesProgress' => boolval( $shortcode->getVal( 'allowTouchMove', '1' ) ),
		'grabCursor'          => boolval( $shortcode->getVal( 'grabCursor', '1' ) ),
		'mousewheel'          => boolval( $shortcode->getVal( 'mousewheel' ) )
	];
else
	$option = $shortcode->getSwiperOption();


if ( $effect_slider === 'dsn-webgl' && $shortcode->getVal( "autoplay" ) )
	$option['autoplay'] = [
		'delay'                => $shortcode->getValueNumberSlide( 'delay', 2000 ),
		'disableOnInteraction' => boolval( $shortcode->getVal( 'disableOnInteraction', '1' ) ),
		'reverseDirection'     => boolval( $shortcode->getVal( 'reverseDirection' ) ),
		'stopOnLastSlide'      => boolval( $shortcode->getVal( 'stopOnLastSlide' ) ),
		'waitForTransition'    => boolval( $shortcode->getVal( 'waitForTransition', '1' ) ),
	];

$next_slide = [];

$show_navigation  = $shortcode->getVal( 'show_navigation' );
$show_progressbar = $shortcode->getVal( 'show_pagination' );
$show_nav_slider  = $shortcode->getVal( 'show_nav_slider' );
$show_number      = $shortcode->getVal( 'show_pagination' );


$widget->add_render_attribute( 'main-slider', [
	'class'           => [
		'main-slider v-dark-head-mobile',
		$shortcode->getVal( "direction", 'horizontal' ) === 'horizontal' ? 'has-horizontal' : '',
		$shortcode->getVal( 'dir_nav_slider_arrow', '' ),
		$show_nav_slider,
		$effect_slider,
		$show_navigation || $show_progressbar ? 'has-paginate' : ''

	],
	'data-dsn-option' => json_encode( $option ),
] );

if ( $effect_slider === 'dsn-webgl' )
	$widget->add_render_attribute( 'main-slider', 'data-dsn-webgl', json_encode( [
		'displacement' => BLACKDSN__PLUGIN_DIR_URL . 'assets/img/displacement/' . $shortcode->getVal( 'transition_slider',
				'8.jpg' ),
		'intensity'    => $shortcode->getValueNumberSlide( 'intensity', - 2 ),
		'speed_in'     => $shortcode->getValueNumberSlide( 'speed_in', 1.2 ),
		'speed_out'    => $shortcode->getValueNumberSlide( 'speed_out', 1.2 )
	] ) );


$is_custom = $shortcode->getVal( 'dsn_views' );


$myposts = $shortcode->getVal( 'items', array() );

if ( ! $is_custom ):
	$myposts = get_posts( array(
		'posts_per_page' => $shortcode->getValueNumberSlide( 'blog_pages_show_at_most',
			get_option( 'posts_per_page' ) ),
		'post_type'      => blackdsn_project_slug(),
		'offset'         => $shortcode->getVal( 'offset', 0 ),
		'orderby'        => $shortcode->getVal( 'orderby', 'date' ),
		'order'          => $shortcode->getVal( 'order', 'DESC' ),
	) );
endif;


$content = '';

/**
 *  Display Content Area
 */
$show_title_area  = $shortcode->getVal( 'show_title_area', array( 'link_with_title', 'show_category' ) );
$link_with_title  = in_array( 'link_with_title', $show_title_area );
$show_sub_title   = in_array( 'show_sub_title', $show_title_area );
$show_category    = in_array( 'show_category', $show_title_area );
$show_description = in_array( 'show_description', $show_title_area );
$show_info        = in_array( 'show_info', $show_title_area );
$show_button1     = in_array( 'show_Button1', $show_title_area );
$show_button2     = in_array( 'show_Button2', $show_title_area );
$show_number      = in_array( 'show_number', $show_title_area );

$show_button = $shortcode->getVal( 'show_button' );
$text_button = $shortcode->getVal( 'text_button' );


$isDirectionCatBefore = $shortcode->getVal( 'direction_cat' );
$use_cat_border       = $shortcode->getVal( 'use_cat_border' );

?>


<!-- ========== Slider Parallax ========== -->
<div <?php $widget->print_render_attribute_string( 'main-slider' ) ?>>


    <div class="content-slider slide-inner h-100 over-hidden">
        <div class="bg-container p-absolute  dsn-hero-parallax-img  w-100 h-100 z-index-1 dsn-hero-parallax-img">
            <div class="swiper swiper-container  h-100">
                <div class="swiper-wrapper">
					<?php
					foreach ( $myposts as $index => $the_p ):
						$shortcode->setSubBlock( $the_p );


						$id  = $shortcode->getSubVal( 'ID' );
						$doc = blackdsn_doc_elementor( $id );


						$slider_item = $shortcode->getItemKey( 'slide-item', $index );
						$widget->add_render_attribute( $slider_item, [
							'class'       => 'slide-item swiper-slide over-hidden',
							'data-dsn-id' => $index,
						] );


						$slider_image = $shortcode->getItemKey( 'slide-image', $index );

						$widget->add_render_attribute( $slider_image, [
							'class' => 'image-bg cover-bg w-100 h-100 before-z-index',
						] );
						$shortcode->add_parallax_attributes( $slider_image, 'parallax_image' );

						$shortcode->add_overlay_attributes( $slider_image, $id, $is_custom, $doc );

						printf( '<div %s>', $widget->get_render_attribute_string( $slider_item ) );

						/**
						 * Image
						 */
						if ( ! $is_custom ):

							blackdsn_get_img( array(
								'before'   => sprintf( '<div %1$s>',
									$widget->get_render_attribute_string( $slider_image ) ),
								'after'    => '</div>',
								'before_v' => sprintf( '<div %1$s> %2$s',
									$widget->get_render_attribute_string( $slider_image ), '<div data-dsn="video">' ),
								'after_v'  => '</div></div>',
								'type'     => 'img',
								'size'     => $doc->getVal( 'image_size', 'full' ),


								'attr' => array(
									'class'             => 'cover-bg-img dsn-swiper-parallax-transform',
									'data-dsn-position' => esc_attr( blackdsn_position_image( '50', $id ) ),
								),
							), $id );
						else:
							printf( '<div %1$s>%2$s</div>',
								$widget->get_render_attribute_string( $slider_image ),
								$shortcode->getAttachImage( $shortcode->getSubVal( 'image' ),
									$shortcode->getSubVal( 'image_size' ), [ 'class' => 'cover-bg-img' ] ) );
						endif;


						$next_slide[ $index ] = "<div class='box-title'><h6 class='sm-title-block'>{$shortcode->getSubVal( 'post_title' )}</h6></div>";
						/**
						 * End Image
						 */


						$subtitle = '';
						if ( $show_sub_title && $subtitle = $shortcode->getSubVal( 'subtitle', '', $id ) ) {
							$subtitle = sprintf( '<div class="metas mb-20 swiper-animate-head"><span>%s<span/></div>',
								$subtitle );
						}


						//--> Category
						$category = '';
						if ( ! $is_custom && $show_category && $category = \DesignGrid\BlackdsnOption::PostCategory( '<span> - </span>',
								blackdsn_category_slug(), false, $id, '<span>', '</span>' ) ) {

							$category = sprintf( '<div class="p-relative head-meta swiper-animate-head %3$s d-flex justify-content-between %1$s"><div class="circle-before metas %4$s">%2$s</div></div>',
								$isDirectionCatBefore ? 'mb-20' : 'mt-20',
								$category,
								$use_cat_border ? ( $isDirectionCatBefore ? 'border-bottom' : 'border-top' ) : '',
								$isDirectionCatBefore ? 'mb-10' : 'mt-10'

							);
						}


						//-->title
						$title = blackdsn_shortcode_render( 'slider-project/title', $shortcode, [
							'index'           => $index,
							'link_with_title' => $link_with_title,
						] );


						$description = blackdsn_shortcode_render( 'slider-project/description', $shortcode, [
							'index'            => $index,
							'show_description' => $show_description,
						] );


						$button1 = blackdsn_shortcode_render( 'slider-project/button', $shortcode, [
							'index'       => $index,
							'key'         => '1',
							'show_button' => $show_button1,
						] );

						$button2 = blackdsn_shortcode_render( 'slider-project/button', $shortcode, [
							'index'       => $index,
							'key'         => '2',
							'show_button' => $show_button2 && $shortcode->getVal( 'dsn_views' ),
						] );


						$tag_button_start = '';
						$tag_button_end   = '';
						if ( $show_button1 || $show_button2 ) {
							$tag_button_start = '<div class="d-flex mt-20 dsn-def-btn dsn-border-style">';
							$tag_button_end   = '</div>';
						}


						/**
						 * Content
						 */
						$slid_content = $shortcode->getItemKey( 'slid_content', $index );
						$widget->add_render_attribute( $slid_content, [
							'class'       => [
								'slide-content',
								'p-absolute',
								( $index === 0 ? 'dsn-active dsn-active-animate' : '' )
							],
							'data-dsn-id' => $index,
						] );
						$content .= sprintf( '<div %1$s>%2$s %3$s %4$s %5$s %6$s </div>',
							$widget->get_render_attribute_string( $slid_content ),
							$subtitle,
							$isDirectionCatBefore ? $category : '',
							$title . ( $isDirectionCatBefore ? '' : $category ),
							$description,
							$tag_button_start . $button1 . $button2 . $tag_button_end
						);

						/**
						 * End Content
						 */

						echo '</div>';


					endforeach;
					?>

                </div>
            </div>
        </div>

		<?php
		$widget->add_render_attribute( 'dsn-slider-content', 'class',
			'dsn-slider-content dsn-hero-parallax-title p-relative h-100 w-100 dsn-container d-flex w-100 h-100 z-index-2 section-padding' );

		printf( '<div %1$s>%2$s</div>', $widget->get_render_attribute_string( 'dsn-slider-content' ), $content )
		?>


    </div>

	<?php if ( $show_navigation ): ?>
        <div class="dsn-swiper-paginate">
            <div class="swiper-pagination dsn-swiper-circle mr-30 ml-30 heading-color"></div>
        </div>
	<?php
	endif;
	if ( $show_progressbar || $show_nav_slider ): ?>
        <div class="control-nav w-100  d-flex dsn-container  align-items-center">

			<?php if ( $show_nav_slider ): ?>
                <div class="prev-paginate  dsn-paginate-arrow box-shadow">

                    <div class="swiper-wrapper">
						<?php if ( count( $next_slide ) ):
							printf( '<div class="swiper-slide"><div class="box-content w-100 d-flex align-items-center">%s</div></div>',
								blackdsnSvg::ARROW_SLIDER_LEFT . $next_slide[ count( $next_slide ) - 1 ] );
							for ( $x = 0; $x < count( $next_slide ) - 1; $x ++ ):
								printf( '<div class="swiper-slide"><div class="box-content w-100 d-flex align-items-center" >%s</div></div>',
									blackdsnSvg::ARROW_SLIDER_LEFT . $next_slide[ $x ] );
							endfor;

						endif;
						?>
                    </div>

                </div>

				<?php if ( $show_progressbar ): ?>

                    <div class="dsn-pagination p-relative w-50 d-flex align-items-end">
                        <span class="slider-current-index h2">01</span>
                        <span class="sm-title-block">/ </span><span
                                class="total sm-title-block"> <?php echo count( $next_slide ) ?></span>
                    </div>

				<?php endif; ?>
                <div class="next-paginate dsn-paginate-arrow box-shadow">

                    <div class="swiper-wrapper">
						<?php if ( count( $next_slide ) ):
							for ( $x = 1; $x < count( $next_slide ); $x ++ ):
								printf( '<div class="swiper-slide"><div class="box-content w-100 d-flex align-items-center justify-content-end" >%s</div></div>',
									$next_slide[ $x ] . blackdsnSvg::ARROW_SLIDER_RIGHT );
							endfor;
							printf( '<div class="swiper-slide"><div class="box-content w-100 d-flex align-items-center justify-content-end">%s</div></div>',
								$next_slide[0] . blackdsnSvg::ARROW_SLIDER_RIGHT );
						endif;
						?>
                    </div>


                </div>

			<?php endif; ?>

        </div>

	<?php endif; ?>


</div>
<!-- ========== End Slider Parallax ========== -->
