<?php
/**
 * @var $shortcode \blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$option    = get_query_var( 'content' );

if ( ! $option['show_button'] ) {
	return '';
}

$key = $option['key'];

$button = new \blackdsnShortCode( $shortcode );
$button->setWidgetBase( $shortcode->getWidgetBase() );


$array_block = [
	'text'       => $shortcode->getSubVal( 'text_link' . $key, esc_html__( "VIEW CASE", 'blackdsn' ) ),
	'icon_align' => 'left',
	'icon'       => $shortcode->getVal( 'with_line_' . $key ) ? '' : [
		"value"   => "fas fa-angle-right",
		"library" => "fa-regular"
	]
];


if ( $shortcode->getVal( 'dsn_views' ) && $link = $shortcode->getSubVal( 'link' . $key ) ) {
	$array_block['link'] = $link;
} else {

	$button->getWidgetBase()->add_render_attribute( 'link', [
		'href'          => get_the_permalink( $shortcode->getSubVal( 'ID' ) ),
		'class'         => 'effect-ajax',
		'data-dsn-ajax' => 'slider',
		'data-dsn'      => 'parallax'

	], null, true );

}


$button->setBlock( $array_block );


$button->getWidgetBase()->add_render_attribute( 'link', [
	'class' => [
		' mr-15',
		$shortcode->getVal( 'with_line_' . $key ),
		$shortcode->getVal( 'bg_ver_button-' . $key, '' ),
		$shortcode->getVal( 'bg_button-' . $key, 'background-transparent' )
	]

], null, true );

echo blackdsn_shortcode_render_group( 'button', array( 'widget-base' => $button ) );