<?php

/**
 * @var $shortcode arctitShortCode
 */
$shortcode = get_query_var( 'attr' );
$option    = get_query_var( 'content' );

$widget = $shortcode->getWidgetBase();

$title_key = $shortcode->getItemKey( 'title', $option['index'] );

$widget->add_render_attribute( $title_key, 'class', 'dsn-title-award ' . $shortcode->getVal( 'dsn-title-skills', 'sm-title-block' ) );
$widget->add_render_attribute( $title_key, 'class', 'mt-30' );

$description_key = $shortcode->getItemKey( 'description', $option['index'] );

$widget->add_render_attribute( $description_key, 'class', 'mt-10' );

?>

<div class="bar-svg">
	<?php
	if ( $num = $shortcode->getSubVal( 'number', '50' ) ) :
		$widget->add_render_attribute( 'number', 'class', 'v-middle' );

		$widget->add_render_attribute( 'fill', [
			'class' => [
				'fill-bar p-relative',
				$shortcode->getVal( 'bg_item', 'background-transparent' ),
				$shortcode->getVal( 'bg_ver_item', '' )
			],

		], null, true );

		$widget->add_render_attribute( 'fill-bar', [
			'class' => 'progress-bar__progress js-progress-bar dsn-animate-skill ',
			'style' => 'stroke-dashoffset:' . ( 100 - $num ) . ';'

		], null, true );
		?>
        <div <?php $widget->print_render_attribute_string( 'fill' ) ?>>
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="-1 -1 34 34">
                <circle cx="16" cy="16" r="15.9155" class="progress-bar__background"/>
                <circle cx="16" cy="16"
                        r="15.9155" <?php $widget->print_render_attribute_string( 'fill-bar' ) ?> />
            </svg>
			<?php printf( '<h4 %1$s>%2$s</h4>', $widget->get_render_attribute_string( 'number' ), $num . "%" ) ?>

        </div>
	<?php endif; ?>

	<?php
	if ( $title = $shortcode->getSubVal( 'title', esc_html__( 'Enter Text Skills', 'arctit' ) ) ) {

		printf( '<h5 %1$s>%2$s</h5>', $widget->get_render_attribute_string( $title_key ), $title );
	}

	if ( $description = $shortcode->getSubVal( 'description', esc_html__( 'All kinds of buildings in chematic or working design', 'arctit' ) ) ) {

		printf( '<p %1$s>%2$s</p>', $widget->get_render_attribute_string( $description_key ), $description );
	}
	?>


</div>
