<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content', array() );


$shortcode = new blackdsnShortCode( $attr, $items_key );


$items = $shortcode->getVal( 'items', array() );

if ( ! count( $items ) || ! is_array( $items ) ) {
	return;
}

$widget = $shortcode->getWidgetBase();

$use_overlay_hover = $shortcode->getVal( 'use_overlay_hover', '1' );
$bg_ver_btn        = $shortcode->getVal( 'bg_ver_btn', '' );
$bg_btn            = $shortcode->getVal( 'bg_btn', 'background-main' );


$swiper_item = $shortcode->get_render_swiper_slide_attribute();


$widget->add_render_attribute( 'service-item', 'class', [
	'service-item p-relative grid-item style-box',
	$bg_ver_btn,
	$bg_btn
] );
$widget->add_render_attribute( 'service-item', $swiper_item );


$widget->add_render_attribute( 'service-item-inner', 'class', [ 'service-item-inner number-item h-100' ] );
$shortcode->add_parallax_attributes( 'service-item-inner', 'content' );


foreach ( $items as $index => $item ) :
	$shortcode->setSubBlock( $item );


	//-->title
	$title = blackdsn_shortcode_render( 'service/title', $shortcode, [
		'index' => $index,
	] );


	$description = blackdsn_shortcode_render( 'service/description', $shortcode, [
		'index' => $index,
	] );

	$icon = $shortcode->getIcon( $shortcode->getSubVal( 'icon' ) );

	$link = blackdsn_shortcode_render( 'service/blackdsn', $shortcode, [
		'index' => $index,
	] );

	?>


    <div <?php $widget->print_render_attribute_string( 'service-item' ) ?> >

        <div <?php $widget->print_render_attribute_string( 'service-item-inner' ) ?>>
			<?php if ( $icon ) {
				printf( '<div class="dsn-icon">%1$s</div>', $icon );
			}
			printf( '<div class="service-content p-relative">%1$s %2$s %3$s</div>', $title, $description, $link );

			?>

        </div>
    </div>
	<?php
	if ( $shortcode->getVal( 'with_image' ) && $id = $shortcode->getSubVal( 'image', [ 'id' => false ] )['id'] ):
		?>
        <div class="item-bg cover-bg"
             data-dsn-bg="<?php echo $shortcode->getAttachImageSrc( $id, $shortcode->getSubVal( 'image_size' ) ) ?>"
             data-overlay="4">
        </div>
	<?php endif; ?>
<?php endforeach; ?>


