<?php

/**
 * @var $shortcode blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$option    = get_query_var( 'content' );

$widget = $shortcode->getWidgetBase();

if ( ! $shortcode->getVal( 'show_link', '1' ) ) {
	return;
}

$link_key = $shortcode->getItemKey( 'link', $option['index'] );
$is_link  = $shortcode->getOptionArray( $shortcode->getSubVal( 'link' ), 'url' );

if ( ! $is_link && empty( $is_link ) ) {
	return '';
}


$button = new \blackdsnShortCode( $shortcode );
$button->setWidgetBase( $shortcode->getWidgetBase() );


$array_block = [
	'text'       => $shortcode->getSubVal( 'text_link', esc_html__( "Read More", 'blackdsn' ) ),
	'icon_align' => 'right',
	'bg_btn'     => 'background-section',
	'icon'       => [
		"value"   => "fas fa-angle-right",
		"library" => "fa-regular"
	]
];


$widget->add_link_attributes( 'link' , $shortcode->getSubVal( 'link', array() ) , true );

$button->setBlock( $array_block );
?>
<div class="d-flex mt-20 dsn-def-btn dsn-hover-icon">
	<?php echo blackdsn_shortcode_render_group( 'button', array( 'widget-base' => $button ) ); ?>
</div>

