<?php
/**
 * @var $shortcode arctitShortCode
 */
$shortcode = get_query_var('attr');


$widget = $shortcode->getWidgetBase();
$currency_symbol = $shortcode->getVal('currency_symbol', "dollar");
$currency_symbol = $currency_symbol === 'custom' ? $shortcode->getVal('currency_symbol_custom') : arctit_get_currency_symbol($currency_symbol);
?>
    <div class="price-table-price pt-30">
        <div class="d-flex">
            <?php
            if ($currency_symbol):
                printf('<span class="price-currency sm-title-block">%s</span>', $currency_symbol);
            endif;

            if ($price = $shortcode->getVal('price', "30")):
                $widget->add_render_attribute('price', 'class', 'price-int-part title heading-color');
                printf('<span %1$s>%2$s</span>', $widget->get_render_attribute_string('price'), $price);
            endif;

            if ($period = $shortcode->getVal('period', __('Period', 'arctit'))):
                $widget->add_render_attribute('period', 'class', 'price-period');
                printf('<span %1$s>%2$s</span>', $widget->get_render_attribute_string('period'), $period);
            endif;


            ?>
        </div>
        <?php
        if ($shortcode->getVal('sale') && $original_price = $shortcode->getVal('original_price', "50")):
            $widget->add_render_attribute('original_price', 'class', 'price-original-price');
            printf('<span class="price-original-price mt-5">%1$s<span %2$s>%3$s</span></span>',
                $shortcode->getVal('text_original_price', __('Normally', 'arctit')),
                $widget->get_render_attribute_string('original_price'),
                $currency_symbol . $original_price);
        endif;
        ?>

    </div>
<?php
if ($description_price = $shortcode->getVal('description_price', __('Lorem ipsum dolor sit amdoet, consectetur adipiscing elitde us uodtempor incidminim.', 'arctit'))):
    $widget->add_render_attribute('description_price', 'class', 'mt-30');
    printf('<p %1$s>%2$s</p>', $widget->get_render_attribute_string('description_price'), $description_price);
endif;