<?php
$attr    = get_query_var( 'attr' );
$myposts = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );
$shortcode->setSubBlock( [ 'id_post' => get_the_ID() ] );


$widget = $shortcode->getWidgetBase();


$swiper_item = $shortcode->get_render_swiper_slide_attribute();

$shortcode->add_parallax_attributes( 'dsn-item-content', 'box' );
$widget->add_render_attribute( 'dsn-item-content', 'class', 'box-content d-flex ' );


$shortcode->add_parallax_attributes( 'dsn-post-content', 'content' );
$widget->add_render_attribute( 'dsn-post-content', 'class', 'post-content dsn-bg p-relative z-index-1 d-flex flex-column' );

$shortcode->add_parallax_attributes( 'slide-image', 'image' );

if ( $shortcode->getVal( 'style_post' ) === "cards" && $shortcode->getVal( 'style_cards_post' ) === "box-content-hover" )
	$widget->add_render_attribute( 'dsn-post-content', 'class', 'container' );


$is_card               = $shortcode->getVal( 'style_post', 'cards' ) === 'cards';
$style_cards_post      = $shortcode->getVal( 'style_cards_post', 'box-image-normal' );
$is_box_image_normal   = $style_cards_post === 'box-image-normal';
$is_box_image_blackdsn = $style_cards_post === 'box-image-blackdsn';


echo blackdsn_shortcode_render( 'post/content/scroll', $shortcode, [
	'id'   => 'start',
	'up'   => 'OUR',
	'down' => 'WORK'
] );


if ( $myposts->have_posts() ) :
	while ( $myposts->have_posts() ) :
		$myposts->the_post();


		$widget->add_render_attribute( 'dsn-item-post', 'class', [
			'dsn-item-post  grid-item over-hidden p-relative box-hover-image',
			'post-' . get_the_ID(),
			$is_card ? $style_cards_post : '',
			$shortcode->getVal( 'style_post' ) === "cards" && ! $is_box_image_blackdsn ? 'v-dark-head' : '',
			$shortcode->getVal( 'show_link', '1' ) ? 'dsn-show-link' : '',
			DesignGrid\BlackdsnOption::PostCategorySlug(),
			$shortcode->getVal( 'bg_ver_btn', '' ),
			$shortcode->getVal( 'bg_btn', 'background-main' )
		], true );


		$widget->add_render_attribute( 'dsn-item-post', $swiper_item );


		?>

        <article <?php $widget->print_render_attribute_string( 'dsn-item-post' ) ?> >

            <div <?php $widget->print_render_attribute_string( 'dsn-item-content' ) ?>>

				<?php
				if ( $is_box_image_blackdsn )
					echo blackdsn_shortcode_render( 'post/content/title', $shortcode );
				echo blackdsn_shortcode_render( 'post/content/image', $shortcode );
				?>

                <div <?php $widget->print_render_attribute_string( 'dsn-post-content' ) ?>>

                    <div class="post-title-info">
						<?php
						echo blackdsn_shortcode_render( 'post/content/meta', $shortcode );
						if ( ! $is_box_image_blackdsn )
							echo blackdsn_shortcode_render( 'post/content/title', $shortcode );
						?>
                    </div>

					<?php if ( in_array( $style_cards_post,
							[ 'box-image-normal', 'box-content-hover', 'box-image-blackdsn' ] ) || ! $is_card ): ?>
                        <div class="post-description-info ">
							<?php
							echo blackdsn_shortcode_render( 'post/content/excerpt', $shortcode );
							if ( $is_card && $is_box_image_normal )
								echo blackdsn_shortcode_render( 'post/content/link/normal', $shortcode );
                            elseif ( $is_card && $is_box_image_blackdsn )
								echo blackdsn_shortcode_render( 'post/content/link/blackdsn', $shortcode );

							else
								echo blackdsn_shortcode_render( 'post/content/link/link', $shortcode );
							?>
                        </div>
					<?php endif; ?>

                </div>
            </div>


        </article>

	<?php endwhile;
endif;
wp_reset_postdata();
echo blackdsn_shortcode_render( 'post/content/scroll', $shortcode, [
	'id'   => 'end',
	'up'   => 'AWESOME',
	'down' => 'DESIGNS'
] );


?>

