<?php

/**
 * @var $shortcode blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$widget    = $shortcode->getWidgetBase();

if ( ! $title = get_the_title() ) {
	return;
}


$widget->add_render_attribute( 'title_link', [
	'href'          => esc_url( get_the_permalink() ),
	'class'         => 'effect-ajax init-color',
	'data-dsn-ajax' => 'work'
], null, true );


$widget->add_render_attribute( 'title', [
	'class' => [
		'post-title word-wrap d-inline-block dsn-bg',
		$shortcode->getVal( 'font_size', 'title-block' )
	],
], null, true );


printf( '<%1$s %2$s><a %3$s>%4$s</a></%1$s>',
	$shortcode->getHtmlTag(),
	$widget->get_render_attribute_string( 'title' ),
	$widget->get_render_attribute_string( 'title_link' ),
	$title );
