<?php
/**
 * @var $shortcode blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$option    = get_query_var( 'content' );
$myposts   = $option['my-posts'];

$type_nav_post = $shortcode->getVal( 'pagination_type', 'none' );
if ( $type_nav_post === 'none' && $myposts->max_num_pages <= 1 ) {
	return;
}

$widget = $shortcode->getWidgetBase();

?>

<div class="dsn-p-pag dsn-posts-el d-flex type-p-<?php echo esc_attr( $type_nav_post ) ?>">
	<?php
	if ( $myposts->have_posts() && $type_nav_post === 'ajax' ) :
		$options = array(
			'style_post'            => 'classic',
			'style_cards_post'      => 'box-image-normal',
			'style_metro_post'      => 'dsn-metro-1',
			'image_size'            => 'large',
			'font_size'             => 'title-block',
			'separator_between'     => '||',
			'separator_between_cat' => ', ',
			'meta_data'             => array(),
			'show_excerpt'          => false,
			'excerpt_length'        => 25,
			'show_link'             => '1',
			'text_link'             => esc_html__( "View Case", 'blackdsn' ),
			'bg_ver_btn'            => '',
			'bg_btn'                => 'background-main',
			'include_tax'           => [],
			'operator_tax'          => "NOT IN",
		);

		$attr_query = array();
		foreach ( $options as $key => $val ):
			if ( $key === 'excerpt_length' ) {
				$attr_query[ $key ]['size'] = $shortcode->getValueNumberSlide( $key, $val );
			} else {
				$attr_query[ $key ] = $shortcode->getVal( $key, $val );
			}
		endforeach;

		$widget->add_render_attribute( 'ajax_attr',
			[
				'class'           => [
					'button-load-more p-relative d-block dsn-btn border-radius move-circle image-zoom border-color-heading',
					esc_attr( $shortcode->getVal( 'style_space_pag' ) )
				],
				'data-dsn'        => 'parallax',
				'data-dsn-option' => json_encode( $option['option_query'] ),
				'data-dsn-attr'   => json_encode( $attr_query ),
			] );
		?>
        <div <?php $widget->print_render_attribute_string( 'ajax_attr' ) ?>>
            <span class="dsn-load-progress-ajax h-100">01</span>
            <span class="progress-text progress-load-more d-block"><?php echo $shortcode->getVal( 'load_more_post', __( 'Load More', 'blackdsn' ) ) ?></span>
            <span class="progress-text progress-no-more d-block"><?php echo $shortcode->getVal( 'no_more_post', __( 'No More', 'blackdsn' ) ) ?></span>
        </div>
	<?php
    elseif ( $type_nav_post === 'nav' ) :
		\DesignGrid\BlackdsnOption::Pagination( array(
			'prev_text'          => blackdsn_buttons_pagination( $shortcode->getVal( 'prev_post', __( 'PREV', 'blackdsn' ) ), 'dsn-prev' ),
			'next_text'          => blackdsn_buttons_pagination( $shortcode->getVal( 'next_post', __( 'NEXT', 'blackdsn' ) ) ),
			'before_page_number' => '<span class="dsn-numbers dsn-heading-title title-tag"><span class="number">',
			'after_page_number'  => '</span></span>',
			'total'              => $myposts->max_num_pages,

		), esc_attr( $shortcode->getVal( 'style_space_pag' ) ) );
	endif;

	?>

</div>
