<?php

/**
 * @var $shortcode blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$widget    = $shortcode->getWidgetBase();

if ( ! $shortcode->getVal( 'show_link', '1' ) ) {
	return;
}


$button = new \blackdsnShortCode( $shortcode );
$button->setWidgetBase( $shortcode->getWidgetBase() );


$array_block = [
	'text'       => $shortcode->getVal( 'text_link', esc_html__( "View Case", 'blackdsn' ) ),
	'icon_align' => 'left',
    'bg_btn' => 'background-section',
	'icon'       => [
		"value"   => "fas fa-angle-right",
		"library" => "fa-regular"
	]
];


$button->getWidgetBase()->add_render_attribute( 'link', [
	'href'          => get_the_permalink( $shortcode->getSubVal( 'ID' ) ),
	'class'         => 'effect-ajax',
	'data-dsn-ajax' => 'work'

], null, true );


$button->setBlock( $array_block );
?>
<div class="d-flex mt-20 dsn-def-btn dsn-hover-icon">
	<?php echo blackdsn_shortcode_render_group( 'button', array( 'widget-base' => $button ) ); ?>
</div>

