<?php

/**
 * @var $shortcode blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$widget    = $shortcode->getWidgetBase();


$slider_image = 'slide-image';
$widget->add_render_attribute( 'slide-image', [
	'class'        => 'box-image-bg before-z-index dsn-swiper-parallax-transform',
	'data-overlay' => blackdsn_overlay()
], null, true );


?>
<a class="effect-ajax box-image-link bg-shadow" href="<?php echo esc_url( get_the_permalink() ) ?>" data-dsn-ajax="work"
   title="<?php echo esc_attr( get_the_title() ) ?>">
	<?php blackdsn_get_img(
		array(
			'before'   => sprintf( '<div %1$s>', $widget->get_render_attribute_string( $slider_image ) ),
			'after'    => '</div>',
			'before_v' => sprintf( '<div %1$s> %2$s', $widget->get_render_attribute_string( $slider_image ), '<div data-dsn="video">' ),
			'after_v'  => '</div></div>',
			'type'     => 'img',
			'size'     => $shortcode->getVal( 'image_size', 'large' ),

			'attr' => array(
				'class'             => 'cover-bg-img dsn-swiper-parallax-transform ',
				'data-dsn-position' => esc_attr( blackdsn_position_image() ),
			),
		)
	);
	?>
</a>