<?php
/**
 * @var $shortcode blackdsnShortCode
 */
$shortcode = get_query_var( 'attr' );
$option    = get_query_var( 'content' );
$myposts   = $option['my-posts'];

$type_nav_post = $shortcode->getVal( 'pagination_type', 'none' );
if ( ! $shortcode->getVal( 'filter_bar' ) ) {
	return;
}

$terms = blackdsn_get_filter_categories( $myposts, $shortcode->getVal( 'query_post', "post" ) === blackdsn_project_slug() ? blackdsn_category_slug() : 'category' );


$widget = $shortcode->getWidgetBase();


$widget->add_render_attribute( 'filter_title', 'class', 'filter-title' );
$widget->add_render_attribute( 'all_filter', [
	'class'       => 'active',
	'data-filter' => '*',
	'type'        => 'button',
] );
?>


<div class="dsn-filtering z-index-1 p-relative w-100 mb-50">
    <div class="filtering-t">
        <div class="filtering-wrap">
            <h5 <?php $widget->print_render_attribute_string( 'filter_title' ) ?> >
				<?php echo esc_html( $shortcode->getVal( 'filter_title', esc_html__( 'Filter', 'blackdsn' ) ) ) ?>
            </h5>
            <div class="filtering">
                <button <?php $widget->print_render_attribute_string( 'all_filter' ) ?> >
					<?php echo esc_html( $shortcode->getVal( 'all_filter', esc_html__( 'All', 'blackdsn' ) ) ) ?>
                </button>
				<?php
				if ( count( $terms ) ):
					foreach ( $terms as $slug => $name ):?>
                        <button type="button"
                                class="<?php echo 'dsn-filter-category-' . esc_attr( $slug ); ?>"
                                data-filter='.<?php echo esc_attr( $slug ); ?> , .<?php echo 'category-' . esc_attr( $slug ); ?>'>
							<?php echo esc_html( $name ); ?>
                        </button>
					<?php endforeach;
				endif;
				?>
            </div>
        </div>
    </div>
</div>
