<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();
$title  = $shortcode->getVal( 'title' );

$widget->add_render_attribute( 'nav-arrow', [
	'data-dsn-title' => $title,
	'data-dsn-id'    => $widget->get_id(),
	'class'          => [ 'dsn-nav-arrow d-flex', 'dsn-id-' . $widget->get_id() ]
] );

$widget->add_render_attribute( 'nav-icon-right', [
	'class' => [
		$shortcode->getVal( 'border_color_btn', 'border-color-default' ),
		$shortcode->getVal( 'bg_ver_btn', '' ),
		$shortcode->getVal( 'bg_btn', 'background-section' )
	]
] );


if ( $shortcode->getVal( 'parallax' ) )
	$widget->add_render_attribute( 'nav-icon-right', [
		'data-dsn' => 'parallax',
		'class'    => [ $shortcode->getVal( 'zoom' ), $shortcode->getVal( 'move_circle' ) ],
	] );

$widget->add_render_attribute( 'nav-icon-left', $widget->get_render_attributes( 'nav-icon-right' ) );


$widget->add_render_attribute( 'nav-icon-right', 'class', 'dsn-nav-right' );
$widget->add_render_attribute( 'nav-icon-left', 'class', 'dsn-nav-left' );

?>

<div <?php $widget->print_render_attribute_string( 'nav-arrow' ) ?> >
    <div <?php $widget->print_render_attribute_string( 'nav-icon-left' ) ?> >
        <div class="dsn-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25">
                <g>
                    <polygon
                            points="24 12.001 2.914 12.001 8.208 6.706 7.501 5.999 1 12.501 7.5 19.001 8.207 18.294 2.914 13.001 24 13.001 24 12.001"/>
                </g>
            </svg>
        </div>

    </div>
    <div <?php $widget->print_render_attribute_string( 'nav-icon-right' ) ?> >
        <div class="dsn-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25">
                <g>
                    <polygon
                            points="24 12.001 2.914 12.001 8.208 6.706 7.501 5.999 1 12.501 7.5 19.001 8.207 18.294 2.914 13.001 24 13.001 24 12.001"/>
                </g>
            </svg>
        </div>
    </div>
</div>

