<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );
$widget    = $shortcode->getWidgetBase();


$widget->add_render_attribute( 'dsn-gallery',
	[
		'class'           => [
			'section-image section-move-image use-horizontal-scroll-image ',
			$shortcode->getVal( 'position_move', '' ),
		],
		'data-dsn-option' => json_encode( [
			'speed' => (float) $shortcode->getValueNumberSlide( 'speed_scroll', 0 ),
			'start' => $shortcode->getVal( 'start_scroll', 0 ),
			'end'   => $shortcode->getVal( 'end_scroll', 0 ),
			'pin'   => boolval( $shortcode->getVal( 'pin_scroll' ) )

		] )

	]
);

$gallery = $shortcode->getVal( 'gallery' );


?>


<div <?php $widget->print_render_attribute_string( 'dsn-gallery' ) ?>>

	<?php
	if ( count( $gallery ) ): ?>


		<?php foreach ( $gallery as $img ): ?>
            <div class="grid-item">
                <div class="image-item">
					<?php echo wp_get_attachment_image( $img['id'], $shortcode->getVal( 'gallery_size' ), false,
						[ 'class' => 'cover-bg-img' ] ) ?>
                </div>
            </div>
		<?php endforeach; ?>

	<?php endif; ?>
</div>
