<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$items = $shortcode->getVal( 'items', array() );

$widget = $shortcode->getWidgetBase();

$options = $shortcode->getSwiperOption();


if ( ! count( $items ) ) {
	return;
}


$widget->add_render_attribute( 'item-img', [
	'class' => 'item-img',
] );

$shortcode->add_parallax_attributes( 'item-img', 'parallax_image' );


$widget->add_render_attribute( 'dsn-swiper', [
	'class'           => 'blackdsn-swiper-slider blackdsn-media-swiper dsn-swiper',
	'data-dsn-option' => json_encode( $options ),
] );

$widget->add_render_attribute( 'swiper-slide', [
	'class' => [
		'swiper-slide over-hidden',
		$shortcode->getVal( 'bg_ver_item', '' ),
		$shortcode->getVal( 'bg_item', 'background-transparent' ),
	],
] );


$swiper_slide = $widget->get_render_attribute_string( 'swiper-slide' );
$item_image   = $widget->get_render_attribute_string( 'item-img' );

?>
<div <?php $widget->print_render_attribute_string( 'dsn-swiper' ) ?>>
    <div class="swiper-container">
        <div class="swiper-wrapper">
			<?php foreach ( $items as $index => $item ):
				$img                           = new blackdsnShortCode( $attr );
				$item['use_scrolling_effects'] = false;
				$img->setBlock( $item );

				$link = '';
				if ( $img->getVal( 'type_slide' ) === 'video' ) {
					$widget->add_link_attributes( 'link', $img->getVal( 'link' ) )
					       ->add_render_attribute( 'link', [
						       'class'    => 'vid play-btn zoom-image background-theme init-color',
						       'rel'      => 'noopener script',
						       'data-dsn' => 'parallax',
					       ] );
					$shortcode->add_parallax_attributes( 'link', 'parallax_video' );


					$link = sprintf( '<div class="content v-middle z-index-3"><a %1$s>%2$s</a></div>', $widget->get_render_attribute_string( 'link' ), blackdsnSvg::PLAY );
				}


				printf( '<div  %1$s ><div %2$s>%3$s</div>%4$s</div>',
					$swiper_slide, $item_image,
					blackdsn_shortcode_render_group( 'image', array( 'widget-base' => $img ), array( 'caption' => $shortcode->getItemKey( 'caption', $index ) ) ),
					$link
				);
				foreach ( $img->getWidgetBase()->get_render_attributes() as $key => $attrs ):
					$img->getWidgetBase()->remove_render_attribute( $key );
				endforeach;

			endforeach; ?>
        </div>

		<?php $shortcode->print_content_paginate_render( array(
			'class' => 'hesham',
		) ); ?>

    </div>
</div>
