<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();

$items = $shortcode->getVal( 'items', array() );


if ( ! count( $items ) ) {
	return;
}


$html_tag = $shortcode->getHtmlTag();

$list_with_number = $shortcode->getVal( 'list_with_number' );
$widget->add_render_attribute( 'list', 'class', 'dsn-list' );


$widget->add_render_attribute( 'list-item', 'class', 'list-item grid-item d-flex align-items-center' );


foreach ( $items as $index => $item ):
	$shortcode->setSubBlock( $item );
	$ren_text = $shortcode->getItemKey( 'text', $index );
	$text     = $shortcode->getSubVal( 'text' );
	$widget->add_render_attribute( $ren_text, 'class', [
		'dsn-heading-title',
		$shortcode->getVal( 'title_color' ),
		$shortcode->getSize()
	] );

	$isIcon = ! empty( $shortcode->getSubVal( 'icon', array( 'library' => '' ) )['library'] );

	$widget->add_render_attribute( 'list-item', 'class', [
		'list-item grid-item d-flex align-items-center',
		'elementor-repeater-item-' . $shortcode->getSubVal( '_id' ),
		$shortcode->getVal( 'bg_ver_btn', '' ),
		$shortcode->getVal( 'bg_btn', 'background-transparent' )
	], true );

	?>
    <li <?php $widget->print_render_attribute_string( 'list-item' ) ?> >
		<?php if ( $isIcon && ! $list_with_number ) : ?>
            <span class="dsn-icon mr-15"><?php $shortcode->printIcon( $shortcode->getSubVal( 'icon' ) ) ?></span>
		<?php elseif ( $list_with_number ) : printf( '<span class="number">%s</span>', $index + 1 ); endif;

		if ( $text ) {
			printf( '<%1$s %2$s>%3$s</%1$s>', $html_tag, $widget->get_render_attribute_string( $ren_text ), $text );
		} ?>


    </li>


<?php endforeach; ?>