<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );
$widget    = $shortcode->getWidgetBase();


$option = [];
foreach ( [ 'rowHeight' => 320, 'gutter' => 15 ] as $key => $value ):
	$option [ $key ] = (int) $shortcode->getValStyleRange( $key, $value, false );
endforeach;


$option['lastRow'] = $shortcode->getVal( 'lastRow', 'left' );


$widget->add_render_attribute( 'dsn-gallery', [
	'class'           => 'gallery-portfolio',
	'data-dsn-option' => json_encode( $option ),
] );

$gallery = $shortcode->getVal( 'gallery' );

$group_popup = $shortcode->getVal( 'group_popup' );
if ( ! $group_popup ) {
	$group_popup = $widget->get_id();
}


?>


<div <?php $widget->print_render_attribute_string( 'dsn-gallery' ) ?>>

	<?php
	if ( count( $gallery ) ):
		foreach ( $gallery as $img ):?>
			<?php
			$has_caption = $shortcode->getCaption( [
				'image'          => $img,
				'caption'        => $shortcode->getVal( 'caption' ),
				'caption_source' => $shortcode->getVal( 'caption_source' ),
			] );

			if ( $has_caption ) {
				$has_caption = sprintf( '<div class="cap"><span>%s</span></div>', $has_caption );
			}


			printf( '<div class="link-pop effect-popup fj-gallery-item" data-fancybox="%s" data-src="%s" data-caption="%s">%s %s</div>',
				$group_popup,
				$shortcode->getAttachImageSrc( $img['id'], $shortcode->getVal( 'size_img_popup_size', 'full' ) ),
				strip_tags( $has_caption ),
				wp_get_attachment_image( $img['id'], $shortcode->getVal( 'gallery_size' ), [
					'class' => 'has-top-bottom w-100',
				] ),
				$has_caption
			);

		endforeach;
	endif;
	?>

</div>
