<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content', array() );


$shortcode = new blackdsnShortCode( $attr );

if ( is_array( $items_key ) ) {
	$shortcode->set_items( $items_key );
}


$widget = $shortcode->getWidgetBase();

$title_color   = $shortcode->getVal( 'title_color' );
$content_color = $shortcode->getVal( 'content_color' );
$size          = $shortcode->getSize( 'sm-title-block' );


$items = $shortcode->getVal( 'items', blackdsn_default_info_header() );

if ( ! count( $items ) ) {
	return '';
}


$shortcode->addPrefixClassLayout( 'list-project' );
$shortcode->addAnimateFade( 'list-item' );
$widget->add_render_attribute( 'list-item', 'class', 'grid-item number-item' );


$widget->add_render_attribute( 'list-project', 'class', 'project-info intro-project-list' );


?>


<ul <?php $widget->print_render_attribute_string( 'list-project' ) ?>>

	<?php
	foreach ( $items as $index => $value ):
		$shortcode->setSubBlock( $value );
		$title_key = $shortcode->getItemKey( 'title', $index );
		$widget->add_render_attribute( $title_key, 'class', [ 'title-list-project', $size ] );
		$content_key = $shortcode->getItemKey( 'content', $index );
		$widget->add_render_attribute( $content_key, 'class', 'description-list-project dsn-auto' );


		?>
        <li <?php $widget->print_render_attribute_string( 'list-item' ) ?> >
            <h5 <?php $widget->print_render_attribute_string( $title_key ) ?>><?php $shortcode->printSubVal( 'title' ); ?></h5>
            <p <?php $widget->print_render_attribute_string( $content_key ) ?> ><?php $shortcode->printSubVal( 'content' ); ?></p>
        </li>

	<?php endforeach; ?>

</ul>