<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );

$image = $shortcode->getVal( 'image', [ 'id' => 0, 'url' => false ] );


//dd($image);
if ( ! $image['id'] && ! $image['url'] )
	return;




$widget = $shortcode->getWidgetBase();

$has_caption           = $shortcode->getCaption();
$color_overlay         = $shortcode->getVal( 'color_overlay' );
$use_scrolling_effects = $shortcode->getVal( 'use_scrolling_effects', '1' );
$mouse_effects         = $shortcode->getVal( 'mouse_effects' );

$caption_render = $shortcode->getOptionArray( $items_key, 'caption', 'caption' );


$widget->add_render_attribute( 'parallax', 'class', 'img-box-parallax before-z-index' );
if ( $use_scrolling_effects ) {
	$widget->add_render_attribute( 'parallax',
		[
			'data-dsn-triggerhook' => $shortcode->getVal( 'animate_image_triggerhook', "bottom" ),
			'data-dsn-grid'        => 'move-up',
			'class'                => $shortcode->getVal( 'effect_open_image' )
		]
	);
}


if ( $mouse_effects ) {
	$widget->add_render_attribute( 'parallax', [
		'data-dsn' => 'parallax',
		'class'    => $shortcode->getVal( 'zoom' ),
	] );
}


if ( $color_overlay ) {
	$widget->add_render_attribute( 'parallax', 'style', '--bg-overlay:' . $color_overlay . ';' );
}

$is_popup = $shortcode->getVal( 'use_as_popup' );
if ( $is_popup ) {
	$widget->add_render_attribute( 'parallax', 'class', 'has-popup' )
	       ->add_render_attribute( 'popup', [
		       'class'            => 'effect-popup before-z-index h-100',
		       'data-src'         => $shortcode->getImageSrc(),
		       'data-caption'     => esc_attr( $has_caption ),
		       'data-fancybox'    => $shortcode->getVal( 'group_by_fancybox' ),
		       'data-cursor'      => 'open',
		       'data-dsn-overlay' => $shortcode->getValueNumberSlide( 'opacity_overlay', 0 ),
	       ] );
} else {
	$widget->add_render_attribute( 'parallax', 'data-overlay',
		$shortcode->getValueNumberSlide( 'opacity_overlay', 0 ) );
}


$src_img = $shortcode->getImageParallax( $image );



?>


<div <?php echo $widget->get_render_attribute_string( 'parallax' ) ?>>

	<?php
	if ( $is_popup ) {
		printf( '<div %s>%s</div>', $widget->get_render_attribute_string( 'popup' ), $src_img );
	} else {
		echo $src_img;
	}

	if ( $has_caption )
		printf( '<div class="cap"><span %s>%s</span></div>', $widget->get_render_attribute_string( $caption_render ),
			$has_caption )
	?>

</div>

